/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Status;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Resource;
import tyrex.recovery.LogWriter;
import tyrex.tm.AsyncCompletionCallback;
import tyrex.tm.ControlImpl;
import tyrex.tm.Heuristic;
import tyrex.tm.ResourceImpl;
import tyrex.tm.TransactionDomain;
import tyrex.tm.TyrexTransaction;
import tyrex.tm.XAResourceHelperManager;
import tyrex.tm.XidImpl;
import tyrex.util.Messages;

final class TransactionImpl
implements TyrexTransaction,
Status,
Heuristic {
    private Synchronization[] _syncs;
    private XAResourceHolder[] _enlisted;
    private XAResourceHolder[] _delisted;
    private Resource[] _resources;
    private XidImpl _xid;
    private int _status;
    private SystemException _sysError;
    private boolean _timedOut;
    private TransactionImpl _parent;
    private PropagationContext _pgContext;
    private int _heuristic = 0;
    private ControlImpl _control;
    private TransactionDomain _txDomain;
    private ORB _orb;

    TransactionImpl(XidImpl xidImpl, PropagationContext propagationContext, TransactionDomain transactionDomain) throws Inactive {
        this._xid = xidImpl;
        this._status = 0;
        this._txDomain = transactionDomain;
        this._pgContext = propagationContext;
        try {
            ResourceImpl resourceImpl = new ResourceImpl(this);
            if (this._orb != null) {
                this._orb.connect((Object)resourceImpl);
            }
            this._pgContext.current.coord.register_resource((Resource)resourceImpl);
        }
        catch (RuntimeException runtimeException) {
            throw new Inactive();
        }
        catch (Inactive inactive) {
            throw inactive;
        }
        this._control = new ControlImpl(this, this._pgContext);
        if (this._orb != null) {
            this._control.setORB(this._orb);
        }
    }

    TransactionImpl(XidImpl xidImpl, TransactionImpl transactionImpl, TransactionDomain transactionDomain) {
        this._xid = xidImpl;
        this._status = 0;
        this._txDomain = transactionDomain;
        if (transactionImpl != null) {
            try {
                transactionImpl.registerResource(new ResourceImpl(this));
            }
            catch (IllegalStateException illegalStateException) {}
            this._parent = transactionImpl;
        }
    }

    static /* synthetic */ int access$1(TransactionImpl transactionImpl) {
        return transactionImpl._status;
    }

    private boolean addNewResource(XAResource xAResource) throws SystemException, RollbackException {
        try {
            if (this.shareResource(xAResource, this._enlisted) || this.shareResource(xAResource, this._delisted)) {
                return true;
            }
        }
        catch (XAException xAException) {
            return false;
        }
        XAResourceHolder xAResourceHolder = new XAResourceHolder();
        xAResourceHolder.xa = xAResource;
        try {
            xAResourceHolder.xid = XAResourceHelperManager.getHelper(xAResource).getXid(this._xid.newBranch());
            xAResource.start(xAResourceHolder.xid, 0);
            if (this._enlisted == null) {
                this._enlisted = new XAResourceHolder[1];
                this._enlisted[0] = xAResourceHolder;
            } else {
                XAResourceHolder[] xAResourceHolderArray = new XAResourceHolder[this._enlisted.length + 1];
                System.arraycopy(this._enlisted, 0, xAResourceHolderArray, 0, this._enlisted.length);
                xAResourceHolderArray[this._enlisted.length] = xAResourceHolder;
                this._enlisted = xAResourceHolderArray;
            }
            return true;
        }
        catch (XAException xAException) {
            return false;
        }
        catch (Exception exception) {
            throw new SystemException(exception.toString());
        }
    }

    private boolean areXaResourcesShared(XAResourceHolder[] xAResourceHolderArray, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (n < xAResourceHolderArray.length) {
            if (!xAResourceHolderArray[n].shared) {
                if (bl2 || bl) {
                    return false;
                }
                bl2 = true;
            }
            ++n;
        }
        return true;
    }

    public synchronized void asyncCommit(AsyncCompletionCallback asyncCompletionCallback) throws SystemException, SecurityException, RollbackException {
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        this.securityCheck();
        this.suspendTransaction();
        if (this._status == 1) {
            this._heuristic = 2;
            throw new RollbackException(Messages.message("tyrex.tx.rolledback"));
        }
        Thread thread = new Thread(this.getAsyncCommitRunnable(asyncCompletionCallback));
        this._txDomain.enlistThread(this, thread);
        thread.start();
    }

    public synchronized void asyncRollback(AsyncCompletionCallback asyncCompletionCallback) throws IllegalStateException, SystemException, SecurityException {
        if (this._timedOut) {
            throw new IllegalStateException(Messages.message("tyrex.tx.timedOut"));
        }
        this.securityCheck();
        this.suspendTransaction();
        if (this._sysError != null) {
            throw this._sysError;
        }
        Thread thread = new Thread(this.getAsyncRollbackRunnable(asyncCompletionCallback));
        this._txDomain.enlistThread(this, thread);
        thread.start();
    }

    private void beforeCompletion() {
        if (this._syncs != null) {
            Transaction transaction = this.makeCurrentTransactionIfNecessary();
            if (this._status != 1) {
                int n = this._syncs.length;
                while (--n >= 0) {
                    Synchronization synchronization = this._syncs[n];
                    try {
                        synchronization.beforeCompletion();
                    }
                    catch (Exception exception) {
                        this.error(exception);
                        this._status = 1;
                    }
                }
            }
            if (transaction != null) {
                this.resumeTransaction(transaction);
            }
            if (this._status == 1) {
                this._heuristic = 2;
                return;
            }
        }
    }

    public boolean canUseOnePhaseCommit() {
        if (this._resources != null && this._resources.length > 1) {
            return false;
        }
        if (this._enlisted == null && this._delisted == null) {
            return true;
        }
        if (this._resources != null && (this._enlisted != null || this._delisted != null)) {
            return false;
        }
        if (this._enlisted != null && this._enlisted.length == 1 && this._delisted == null) {
            return true;
        }
        if (this._delisted != null && this._delisted.length == 1 && this._enlisted == null) {
            return true;
        }
        if (this._enlisted != null) {
            if (!this.areXaResourcesShared(this._enlisted, false)) {
                return false;
            }
            if (this._delisted != null) {
                return this.areXaResourcesShared(this._delisted, true);
            }
            return true;
        }
        if (this._delisted != null) {
            return this.areXaResourcesShared(this._delisted, false);
        }
        return true;
    }

    public synchronized void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        if (this._parent != null || this._pgContext != null) {
            return;
        }
        this.commit(this.canUseOnePhaseCommit());
    }

    private void commit(boolean bl) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        this._txDomain.stopTxTimer(this);
        LogWriter.out.commit_begin(this._xid, bl ^ true);
        try {
            this._txDomain.notifyCommit(this._xid);
            if (!bl) {
                this.prepare();
            } else {
                this.endResources();
            }
        }
        catch (RollbackException rollbackException) {
            this._heuristic = 2;
        }
        switch (this._heuristic) {
            case 0: {
                try {
                    this._txDomain.notifyCompletion(this._xid, this._heuristic);
                    this._status = 3;
                    java.lang.Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    java.lang.Object var3_3 = null;
                    try {
                        this.forgetReadOnly();
                    }
                    catch (IllegalStateException illegalStateException) {}
                    throw throwable;
                }
                try {
                    this.forgetReadOnly();
                }
                catch (IllegalStateException illegalStateException) {}
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 32: 
            case 48: {
                try {
                    this._status = 1;
                    this.internalRollback();
                    throw new HeuristicRollbackException(Messages.message("tyrex.tx.rolledback"));
                }
                catch (Throwable throwable) {
                    java.lang.Object var3_4 = null;
                    try {
                        this.forgetOnRollback();
                    }
                    catch (IllegalStateException illegalStateException) {}
                    LogWriter.out.commit_end(this._xid, this._heuristic);
                    LogWriter.out.completed(this._xid);
                    throw throwable;
                }
            }
            default: {
                try {
                    this.internalCommit(bl);
                }
                catch (Throwable throwable) {
                    java.lang.Object var3_6 = null;
                    try {
                        this.forgetOnCommit();
                    }
                    catch (IllegalStateException illegalStateException) {}
                    LogWriter.out.commit_end(this._xid, this._heuristic);
                    LogWriter.out.completed(this._xid);
                    throw throwable;
                }
                java.lang.Object var3_5 = null;
                try {
                    this.forgetOnCommit();
                }
                catch (IllegalStateException illegalStateException) {}
                LogWriter.out.commit_end(this._xid, this._heuristic);
                LogWriter.out.completed(this._xid);
                break;
            }
        }
        switch (this._heuristic) {
            case 2: {
                throw new HeuristicRollbackException(Messages.message("tyrex.tx.heuristicRollback"));
            }
            case 4: {
                throw new HeuristicMixedException(Messages.message("tyrex.tx.heuristicMixed"));
            }
            case 8: {
                throw new HeuristicMixedException(Messages.message("tyrex.tx.heuristicHazard"));
            }
            case 32: 
            case 48: {
                if (this._sysError != null) {
                    throw this._sysError;
                }
                throw new SystemException("Unknown exception occurred");
            }
        }
        if (this._sysError != null) {
            throw this._sysError;
        }
    }

    private void commitXAResources(XAResourceHolder[] xAResourceHolderArray, boolean bl) {
        int n = 0;
        while (n < xAResourceHolderArray.length) {
            XAResourceHolder xAResourceHolder = xAResourceHolderArray[n];
            try {
                if (!xAResourceHolder.shared && !xAResourceHolder.readOnly) {
                    xAResourceHolder.xa.commit(xAResourceHolder.xid, bl);
                    this._heuristic |= 1;
                }
            }
            catch (XAException xAException) {
                this.xaExceptionOccurred(xAException);
            }
            catch (Exception exception) {
                this._heuristic |= 0x30;
                this.error(exception);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        switch (this._status) {
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
            case 0: 
            case 1: 
        }
        if (this._enlisted == null) {
            return false;
        }
        XAResourceHolder xAResourceHolder = null;
        int n2 = 0;
        while (n2 < this._enlisted.length) {
            xAResourceHolder = this._enlisted[n2];
            if (xAResourceHolder.xa == xAResource) break;
            ++n2;
        }
        if (n2 == this._enlisted.length) {
            return false;
        }
        switch (n) {
            case 0x2000000: {
                try {
                    xAResourceHolder.xa.end(xAResourceHolder.xid, 0x2000000);
                    xAResourceHolder.endFlag = 0x2000000;
                    return true;
                }
                catch (XAException xAException) {
                    return false;
                }
                catch (Exception exception) {
                    throw new SystemException(exception.toString());
                }
            }
            case 0x4000000: 
            case 0x20000000: {
                boolean bl;
                try {
                    try {
                        XAResourceHolder[] xAResourceHolderArray;
                        if (this._enlisted.length == 1) {
                            this._enlisted = null;
                        } else {
                            this._enlisted[n2] = this._enlisted[this._enlisted.length - 1];
                            xAResourceHolderArray = new XAResourceHolder[this._enlisted.length - 1];
                            System.arraycopy(this._enlisted, 0, xAResourceHolderArray, 0, this._enlisted.length - 1);
                            this._enlisted = xAResourceHolderArray;
                        }
                        if (n == 0x20000000) {
                            xAResourceHolder.xa.end(xAResourceHolder.xid, 0x20000000);
                            xAResourceHolder.xa = null;
                            xAResourceHolder.xid = null;
                        } else {
                            xAResourceHolder.xa.end(xAResourceHolder.xid, 0x4000000);
                            if (this._delisted == null) {
                                this._delisted = new XAResourceHolder[]{xAResourceHolder};
                            } else {
                                xAResourceHolderArray = new XAResourceHolder[this._delisted.length + 1];
                                System.arraycopy(this._delisted, 0, xAResourceHolderArray, 0, this._delisted.length);
                                xAResourceHolderArray[this._delisted.length] = xAResourceHolder;
                                this._delisted = xAResourceHolderArray;
                            }
                        }
                        xAResourceHolder.endFlag = n;
                        bl = true;
                        java.lang.Object var8_10 = null;
                        if (n != 0x20000000) return bl;
                    }
                    catch (XAException xAException) {
                        boolean bl2 = false;
                        java.lang.Object var8_11 = null;
                        if (n != 0x20000000) return bl2;
                        this.setRollbackOnly();
                        return bl2;
                    }
                    catch (Exception exception) {
                        throw new SystemException(exception.toString());
                    }
                }
                catch (Throwable throwable) {
                    java.lang.Object var8_12 = null;
                    if (n == 0x20000000) {
                        this.setRollbackOnly();
                    }
                    throw throwable;
                }
                this.setRollbackOnly();
                return bl;
            }
        }
        throw new IllegalArgumentException(Messages.message("tyrex.tx.invalidFlag"));
    }

    private void endEnlistedResourcesForCommit() {
        if (this._enlisted != null) {
            int n = 0;
            while (n < this._enlisted.length) {
                try {
                    this.endForTransactionBoundary(this._enlisted[n]);
                }
                catch (Exception exception) {
                    this._heuristic |= 2;
                    this.error(exception);
                }
                ++n;
            }
        }
    }

    private void endForTransactionBoundary(XAResourceHolder xAResourceHolder) throws SystemException, XAException {
        if (xAResourceHolder.endFlag == 0 || xAResourceHolder.endFlag == 0x2000000) {
            if (xAResourceHolder.endFlag == 0x2000000) {
                XAResourceHelperManager.getHelper(xAResourceHolder.xa).endSuspended(xAResourceHolder.xa, xAResourceHolder.xid);
            } else {
                xAResourceHolder.xa.end(xAResourceHolder.xid, 0x4000000);
            }
            xAResourceHolder.endFlag = 0x4000000;
        } else if (xAResourceHolder.endFlag != 0x4000000) {
            throw new SystemException("XA resource is not in the proper state to be ended");
        }
    }

    void endResources() throws IllegalStateException, RollbackException {
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        switch (this._status) {
            case 2: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inOnePhaseCommit"));
            }
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            case 1: {
                this._heuristic = 2;
                return;
            }
            case 4: {
                throw new RollbackException(Messages.message("tyrex.tx.rolledback"));
            }
            case 9: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inRollback"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
            case 0: 
        }
        this.securityCheck();
        Transaction transaction = this.makeCurrentTransactionIfNecessary();
        this._status = 8;
        this._heuristic = 0;
        try {
            this.beforeCompletion();
        }
        finally {
            java.lang.Object var7_2 = null;
            if (transaction != null) {
                this.resumeTransaction(transaction);
            }
        }
        if (this._enlisted != null) {
            this.endEnlistedResourcesForCommit();
        }
        this._heuristic = this._heuristic == 0 ? 1 : this.normalize(this._heuristic);
    }

    public synchronized boolean enlistResource(XAResource xAResource) throws IllegalStateException, SystemException, RollbackException {
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        switch (this._status) {
            case 1: {
                throw new RollbackException(Messages.message("tyrex.tx.markedRollback"));
            }
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
            case 0: 
        }
        if (this._enlisted != null) {
            int n = 0;
            while (n < this._enlisted.length) {
                XAResourceHolder xAResourceHolder = this._enlisted[n];
                if (xAResourceHolder.xa == xAResource) {
                    if (xAResourceHolder.endFlag == 0x2000000) {
                        try {
                            xAResourceHolder.xa.start(xAResourceHolder.xid, 0x8000000);
                            xAResourceHolder.endFlag = 0;
                            return true;
                        }
                        catch (XAException xAException) {
                            return false;
                        }
                        catch (Exception exception) {
                            throw new SystemException(exception.toString());
                        }
                    }
                    return false;
                }
                ++n;
            }
        }
        return this.addNewResource(xAResource);
    }

    public boolean equals(java.lang.Object object) {
        return this == object;
    }

    private void error(Throwable throwable) {
        if (throwable instanceof RemoteException && ((RemoteException)throwable).detail != null) {
            throwable = ((RemoteException)throwable).detail;
        }
        if (throwable instanceof XAException) {
            switch (((XAException)throwable).errorCode) {
                case 100: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbrollback"));
                    break;
                }
                case 106: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbtimeout"));
                    break;
                }
                case 101: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbcommfail"));
                    break;
                }
                case 102: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbdeadlock"));
                    break;
                }
                case 103: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbintegrity"));
                    break;
                }
                case 104: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbother"));
                    break;
                }
                case 105: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rbproto"));
                    break;
                }
                case 8: {
                    throwable = new SystemException(Messages.message("tyrex.xa.heurhaz"));
                    break;
                }
                case 7: {
                    throwable = new SystemException(Messages.message("tyrex.xa.heurcom"));
                    break;
                }
                case 6: {
                    throwable = new SystemException(Messages.message("tyrex.xa.heurrb"));
                    break;
                }
                case 5: {
                    throwable = new SystemException(Messages.message("tyrex.xa.heurmix"));
                    break;
                }
                case 3: {
                    throwable = new SystemException(Messages.message("tyrex.xa.rdonly"));
                    break;
                }
                case -4: {
                    throwable = new SystemException(Messages.message("tyrex.xa.nota"));
                    break;
                }
                default: {
                    throwable = new SystemException(Messages.format("tyrex.xa.unknown", throwable));
                    break;
                }
            }
        }
        this._txDomain.logMessage(String.valueOf(this._xid.toString()) + " : " + throwable.toString());
        if (throwable instanceof RuntimeException && this._txDomain.getLogWriter() != null) {
            throwable.printStackTrace(this._txDomain.getLogWriter());
        }
        if (this._sysError == null) {
            this._sysError = throwable instanceof SystemException ? (SystemException)throwable : new SystemException(throwable.toString());
        }
    }

    private void forget(int n) throws IllegalStateException {
        int n2;
        if (this._status != 3 && this._status != 4) {
            throw new IllegalStateException(Messages.message("tyrex.tx.cannotForget"));
        }
        if (this._heuristic != n && (this._heuristic == 2 || this._heuristic == 1 || this._heuristic == 4 || this._heuristic == 8)) {
            XAResourceHolder xAResourceHolder;
            if (this._enlisted != null) {
                n2 = 0;
                while (n2 < this._enlisted.length) {
                    xAResourceHolder = this._enlisted[n2];
                    try {
                        if (!xAResourceHolder.shared) {
                            xAResourceHolder.xa.forget(xAResourceHolder.xid);
                        }
                    }
                    catch (XAException xAException) {
                        this.error(xAException);
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    xAResourceHolder.xa = null;
                    xAResourceHolder.xid = null;
                    this._enlisted[n2] = null;
                    ++n2;
                }
            }
            this._enlisted = null;
            if (this._delisted != null) {
                n2 = 0;
                while (n2 < this._delisted.length) {
                    xAResourceHolder = this._delisted[n2];
                    try {
                        if (!xAResourceHolder.shared) {
                            xAResourceHolder.xa.forget(xAResourceHolder.xid);
                        }
                    }
                    catch (XAException xAException) {
                        this.error(xAException);
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    xAResourceHolder.xa = null;
                    xAResourceHolder.xid = null;
                    this._delisted[n2] = null;
                    ++n2;
                }
            }
            this._delisted = null;
            if (this._resources != null) {
                n2 = 0;
                while (n2 < this._resources.length) {
                    Resource resource = this._resources[n2];
                    if (resource != null) {
                        try {
                            resource.forget();
                        }
                        catch (Exception exception) {
                            this.error(exception);
                        }
                        this._resources[n2] = null;
                    }
                    ++n2;
                }
            }
        }
        this._enlisted = null;
        this._resources = null;
        this._delisted = null;
        if (this._syncs != null) {
            Transaction transaction = this.makeCurrentTransactionIfNecessary();
            n2 = this._syncs.length;
            while (--n2 >= 0) {
                Synchronization synchronization = this._syncs[n2];
                try {
                    synchronization.afterCompletion(this._status);
                }
                catch (Exception exception) {
                    this.error(exception);
                }
                this._syncs[n2] = null;
            }
            this._syncs = null;
            if (transaction != null) {
                this.resumeTransaction(transaction);
            }
        }
        if (this._parent == null) {
            this._txDomain.forgetTransaction(this);
        }
    }

    void forgetOnCommit() throws IllegalStateException {
        this.forget(1);
    }

    void forgetOnRollback() throws IllegalStateException {
        this.forget(2);
    }

    void forgetReadOnly() throws IllegalStateException {
        this.forget(0);
    }

    private Runnable getAsyncCommitRunnable(final AsyncCompletionCallback asyncCompletionCallback) {
        return new Runnable(){

            public void run() {
                TransactionImpl transactionImpl = this;
                synchronized (transactionImpl) {
                    boolean bl;
                    block7: {
                        bl = false;
                        if (asyncCompletionCallback != null) {
                            asyncCompletionCallback.beforeCompletion(this);
                        }
                        try {
                            this.commit();
                        }
                        catch (Exception exception) {
                            bl = true;
                            if (asyncCompletionCallback == null) break block7;
                            asyncCompletionCallback.exceptionOccurred(this, exception);
                        }
                    }
                    if (!bl && asyncCompletionCallback != null) {
                        asyncCompletionCallback.afterCompletion(this);
                    }
                }
            }
        };
    }

    private Runnable getAsyncRollbackRunnable(final AsyncCompletionCallback asyncCompletionCallback) {
        return new Runnable(){

            public void run() {
                TransactionImpl transactionImpl = this;
                synchronized (transactionImpl) {
                    boolean bl;
                    block7: {
                        bl = false;
                        if (asyncCompletionCallback != null) {
                            asyncCompletionCallback.beforeCompletion(this);
                        }
                        try {
                            this.rollback();
                        }
                        catch (Exception exception) {
                            bl = true;
                            if (asyncCompletionCallback == null) break block7;
                            asyncCompletionCallback.exceptionOccurred(this, exception);
                        }
                    }
                    if (!bl && asyncCompletionCallback != null) {
                        asyncCompletionCallback.afterCompletion(this);
                    }
                }
            }
        };
    }

    synchronized ControlImpl getControl() {
        if (this._control == null) {
            this._control = new ControlImpl(this);
            if (this._orb != null) {
                this._orb.connect((Object)this._control);
                this._control.setORB(this._orb);
            }
        }
        return this._control;
    }

    int getHeuristic() {
        return this._heuristic;
    }

    TransactionImpl getParent() {
        return this._parent;
    }

    PropagationContext getPropagationContext() {
        return this._pgContext;
    }

    public int getStatus() {
        return this._status;
    }

    boolean getTimedOut() {
        return this._timedOut;
    }

    TransactionImpl getTopLevel() {
        if (this._parent == null) {
            return this;
        }
        return this._parent.getTopLevel();
    }

    TransactionDomain getTransactionDomain() {
        return this._txDomain;
    }

    XidImpl getXid() {
        return this._xid;
    }

    public int hashCode() {
        return this._xid.hashCode();
    }

    void internalCommit(boolean bl) throws IllegalStateException {
        if (this._status == 3 || this._status == 4) {
            return;
        }
        if (!bl && this._status != 2 || bl && this._status != 8) {
            throw new IllegalStateException(Messages.message("tyrex.tx.notPrepared"));
        }
        this._status = 8;
        this._heuristic = 0;
        if (this._resources != null) {
            int n = 0;
            while (n < this._resources.length) {
                Resource resource = this._resources[n];
                if (resource != null) {
                    try {
                        if (bl) {
                            resource.commit_one_phase();
                        } else {
                            resource.commit();
                        }
                        LogWriter.out.commit_ots_resource(this._xid, resource);
                        this._heuristic |= 0x101;
                    }
                    catch (HeuristicMixed heuristicMixed) {
                        this._heuristic |= 4;
                    }
                    catch (HeuristicHazard heuristicHazard) {
                        this._heuristic |= 8;
                    }
                    catch (HeuristicRollback heuristicRollback) {
                        this._heuristic |= 2;
                    }
                    catch (Exception exception) {
                        if (exception instanceof TRANSACTION_ROLLEDBACK) {
                            this._heuristic |= 2;
                        }
                        this._heuristic |= 0x30;
                        this.error(exception);
                    }
                }
                ++n;
            }
        }
        if (this._enlisted != null) {
            this.commitXAResources(this._enlisted, bl);
        }
        if (this._delisted != null) {
            this.commitXAResources(this._delisted, bl);
        }
        this._status = 3;
        this._heuristic = this.normalize(this._heuristic);
        this._txDomain.notifyCompletion(this._xid, this._heuristic);
    }

    void internalRollback() {
        int n;
        switch (this._status) {
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            case 9: {
                this._heuristic = 2;
                return;
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
            case 3: 
            case 4: {
                return;
            }
            case 0: 
            case 1: 
        }
        this.securityCheck();
        this._status = 9;
        this._heuristic = 0;
        this.beforeCompletion();
        if (this._resources != null) {
            n = 0;
            while (n < this._resources.length) {
                Resource resource = this._resources[n];
                if (resource != null) {
                    java.lang.Object var5_3;
                    try {
                        try {
                            resource.rollback();
                            this._heuristic |= 0x102;
                            this._resources[n] = null;
                        }
                        catch (HeuristicMixed heuristicMixed) {
                            this._heuristic |= 4;
                        }
                        catch (HeuristicHazard heuristicHazard) {
                            this._heuristic |= 8;
                        }
                        catch (HeuristicCommit heuristicCommit) {
                            this._heuristic |= 1;
                        }
                        catch (Exception exception) {
                            this._heuristic |= 0x30;
                            this.error(exception);
                        }
                        var5_3 = null;
                        LogWriter.out.rollback_ots_resource(this._xid, resource);
                    }
                    catch (Throwable throwable) {
                        var5_3 = null;
                        LogWriter.out.rollback_ots_resource(this._xid, resource);
                        throw throwable;
                    }
                }
                ++n;
            }
        }
        if (this._enlisted != null) {
            n = 0;
            while (n < this._enlisted.length) {
                try {
                    this.endForTransactionBoundary(this._enlisted[n]);
                }
                catch (XAException xAException) {
                    this.xaExceptionOccurred(xAException);
                }
                catch (Exception exception) {
                    this._heuristic |= 0x30;
                    this.error(exception);
                }
                ++n;
            }
            this.rollbackXAResources(this._enlisted);
        }
        if (this._delisted != null) {
            this.rollbackXAResources(this._delisted);
        }
        this._status = 4;
        this._heuristic = this.normalize(this._heuristic);
        this._txDomain.notifyCompletion(this._xid, this._heuristic);
    }

    void internalSetTransactionTimeout(int n) {
        if (this._enlisted != null) {
            int n2 = 0;
            while (n2 < this._enlisted.length) {
                XAResourceHolder xAResourceHolder = this._enlisted[n2];
                try {
                    xAResourceHolder.xa.setTransactionTimeout(n);
                }
                catch (XAException xAException) {}
                ++n2;
            }
        }
    }

    synchronized String[] listResources() {
        int n;
        String[] stringArray = new String[(this._enlisted == null ? 0 : this._enlisted.length) + (this._resources == null ? 0 : this._resources.length)];
        int n2 = 0;
        if (this._enlisted != null) {
            n = 0;
            while (n < this._enlisted.length) {
                stringArray[n2] = XidImpl.toString(this._enlisted[n].xid.getBranchQualifier());
                if (this._enlisted[n].endFlag != 0) {
                    stringArray[n2] = String.valueOf(stringArray[n2]) + " [" + (this._enlisted[n].endFlag == 0x2000000 ? "suspended" : (this._enlisted[n].endFlag == 0x4000000 ? "ended" : "failed")) + "]";
                }
                ++n2;
                ++n;
            }
        }
        if (this._resources != null) {
            n = 0;
            while (n < this._resources.length) {
                stringArray[n2] = this._resources[n].toString();
                ++n2;
                ++n;
            }
        }
        return stringArray;
    }

    private Transaction makeCurrentTransactionIfNecessary() {
        return (Transaction)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                Transaction transaction = null;
                try {
                    if (TransactionImpl.this._txDomain.getTransactionManager().getTransaction() != TransactionImpl.this) {
                        transaction = TransactionImpl.this._txDomain.getTransactionManager().suspend();
                        TransactionImpl.this._txDomain.internalGetTransactionManager().internalResume(TransactionImpl.this, false);
                    }
                }
                catch (Exception exception) {
                    TransactionImpl.this._status = 1;
                    TransactionImpl.this.error(exception);
                }
                return transaction;
            }
        });
    }

    public int normalize(int n) {
        if ((n & 8) != 0) {
            return 8;
        }
        if ((n & 4) != 0) {
            return 4;
        }
        if ((n & 0x20) != 0) {
            return 32;
        }
        if ((n & 0x30) != 0) {
            return 48;
        }
        if (n == 3 || n == 259) {
            return 4;
        }
        return n;
    }

    public synchronized void onePhaseCommit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this._txDomain.stopTxTimer(this);
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        if (this._parent != null || this._pgContext != null) {
            return;
        }
        this.commit(true);
    }

    void prepare() throws IllegalStateException, RollbackException {
        XAResourceHolder xAResourceHolder;
        int n;
        LogWriter.out.prepare_begin(this._xid);
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        switch (this._status) {
            case 2: {
                return;
            }
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            case 1: {
                this._heuristic = 2;
                return;
            }
            case 4: {
                throw new RollbackException(Messages.message("tyrex.tx.rolledback"));
            }
            case 9: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inRollback"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
            case 0: 
        }
        this.securityCheck();
        this._heuristic = 0;
        this._status = 7;
        int n2 = 0;
        this.beforeCompletion();
        if (this._resources != null) {
            n = 0;
            while (n < this._resources.length) {
                if (this._heuristic != 0 && this._heuristic != 1) break;
                Resource resource = this._resources[n];
                if (resource != null) {
                    try {
                        int n3 = resource.prepare().value();
                        LogWriter.out.prepare_ots_resource(this._xid, resource, n3);
                        if (n3 == 2) {
                            this._resources[n] = null;
                        } else if (n3 == 0) {
                            ++n2;
                        } else if (n3 == 1) {
                            this._heuristic |= 2;
                            this._resources[n] = null;
                        }
                    }
                    catch (HeuristicMixed heuristicMixed) {
                        this._heuristic |= 4;
                    }
                    catch (HeuristicHazard heuristicHazard) {
                        this._heuristic |= 8;
                    }
                    catch (Exception exception) {
                        if (exception instanceof TRANSACTION_ROLLEDBACK) {
                            this._heuristic |= 2;
                        }
                        this._heuristic |= 0x30;
                        this.error(exception);
                    }
                }
                ++n;
            }
        }
        if (this._enlisted != null) {
            this.endEnlistedResourcesForCommit();
            n = 0;
            while (n < this._enlisted.length) {
                if (this._heuristic != 0 && this._heuristic != 1) break;
                xAResourceHolder = this._enlisted[n];
                if (xAResourceHolder != null) {
                    try {
                        if (!xAResourceHolder.shared) {
                            if (xAResourceHolder.xa.prepare(xAResourceHolder.xid) == 3) {
                                xAResourceHolder.readOnly = true;
                            } else {
                                ++n2;
                            }
                        }
                    }
                    catch (XAException xAException) {
                        this.xaExceptionOccurred(xAException);
                    }
                    catch (Exception exception) {
                        this._heuristic |= 0x30;
                        this.error(exception);
                    }
                }
                ++n;
            }
        }
        if (this._delisted != null) {
            n = 0;
            while (n < this._delisted.length) {
                if (this._heuristic != 0 && this._heuristic != 1) break;
                xAResourceHolder = this._delisted[n];
                if (xAResourceHolder != null) {
                    try {
                        if (!xAResourceHolder.shared) {
                            if (xAResourceHolder.xa.prepare(xAResourceHolder.xid) == 3) {
                                xAResourceHolder.readOnly = true;
                            } else {
                                ++n2;
                            }
                        }
                    }
                    catch (XAException xAException) {
                        this.xaExceptionOccurred(xAException);
                    }
                    catch (Exception exception) {
                        this._heuristic |= 0x30;
                        this.error(exception);
                    }
                }
                ++n;
            }
        }
        this._status = 2;
        this._heuristic = this._heuristic == 0 && n2 > 0 ? 1 : this.normalize(this._heuristic);
        LogWriter.out.prepare_end(this._xid, this._heuristic);
    }

    synchronized void registerResource(Resource resource) throws IllegalStateException {
        switch (this._status) {
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
            case 0: 
            case 1: 
        }
        if (this._resources == null) {
            this._resources = new Resource[1];
            this._resources[0] = resource;
        } else {
            int n = 0;
            while (n < this._resources.length) {
                if (this._resources[n] == resource) {
                    return;
                }
                ++n;
            }
            Resource[] resourceArray = new Resource[this._resources.length + 1];
            System.arraycopy(this._resources, 0, resourceArray, 0, this._resources.length);
            resourceArray[this._resources.length] = resource;
            this._resources = resourceArray;
            LogWriter.out.register_ots_resource(this._xid, resource);
        }
    }

    public synchronized void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        if (this._timedOut) {
            throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
        }
        switch (this._status) {
            case 1: {
                throw new RollbackException(Messages.message("tyrex.tx.markedRollback"));
            }
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
            case 0: 
        }
        if (this._syncs == null) {
            this._syncs = new Synchronization[1];
            this._syncs[0] = synchronization;
        } else {
            int n = 0;
            while (n < this._syncs.length) {
                if (this._syncs[n] == synchronization) {
                    return;
                }
                ++n;
            }
            Synchronization[] synchronizationArray = new Synchronization[this._syncs.length + 1];
            System.arraycopy(this._syncs, 0, synchronizationArray, 0, this._syncs.length);
            synchronizationArray[this._syncs.length] = synchronization;
            this._syncs = synchronizationArray;
        }
    }

    synchronized void resumeAndEnlistResources(XAResource[] xAResourceArray) throws IllegalStateException, SystemException, RollbackException {
        block18: {
            block17: {
                if (this._timedOut) {
                    throw new RollbackException(Messages.message("tyrex.tx.timedOut"));
                }
                switch (this._status) {
                    case 1: {
                        throw new RollbackException(Messages.message("tyrex.tx.markedRollback"));
                    }
                    case 2: 
                    case 7: 
                    case 8: {
                        throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
                    }
                    default: {
                        throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
                    }
                    case 0: 
                }
                if (this._enlisted == null) break block17;
                int n = this._enlisted.length;
                int n2 = 0;
                while (n2 < n) {
                    XAResourceHolder xAResourceHolder = this._enlisted[n2];
                    if (xAResourceHolder.endFlag == 0x2000000) {
                        try {
                            xAResourceHolder.xa.start(xAResourceHolder.xid, 0x8000000);
                            xAResourceHolder.endFlag = 0;
                        }
                        catch (XAException xAException) {
                        }
                        catch (Exception exception) {
                            throw new SystemException(exception.toString());
                        }
                    }
                    ++n2;
                }
                if (xAResourceArray == null) break block18;
                n2 = 0;
                while (n2 < xAResourceArray.length) {
                    block16: {
                        XAResource xAResource = xAResourceArray[n2];
                        int n3 = 0;
                        while (n3 < n) {
                            if (this._enlisted[n3].xa != xAResource) {
                                ++n3;
                                continue;
                            }
                            break block16;
                        }
                        this.addNewResource(xAResource);
                    }
                    ++n2;
                }
                break block18;
            }
            if (xAResourceArray != null) {
                int n = 0;
                while (n < xAResourceArray.length) {
                    this.addNewResource(xAResourceArray[n]);
                    ++n;
                }
            }
        }
    }

    private void resumeTransaction(final Transaction transaction) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                try {
                    TransactionImpl.this._txDomain.getTransactionManager().suspend();
                }
                catch (Exception exception) {
                    TransactionImpl.this.error(exception);
                }
                try {
                    TransactionImpl.this._txDomain.getTransactionManager().resume(transaction);
                }
                catch (Exception exception) {
                    TransactionImpl.this._status = 1;
                    TransactionImpl.this.error(exception);
                }
                return null;
            }
        });
    }

    public synchronized void rollback() throws IllegalStateException, SystemException {
        this._txDomain.stopTxTimer(this);
        LogWriter.out.rollback_begin(this._xid);
        if (this._timedOut) {
            throw new IllegalStateException(Messages.message("tyrex.tx.timedOut"));
        }
        try {
            this._txDomain.notifyRollback(this._xid);
            this.internalRollback();
        }
        catch (Throwable throwable) {
            java.lang.Object var4_2 = null;
            try {
                this.forgetOnRollback();
            }
            catch (IllegalStateException illegalStateException) {}
            LogWriter.out.rollback_end(this._xid, this._heuristic);
            LogWriter.out.completed(this._xid);
            throw throwable;
        }
        java.lang.Object var4_1 = null;
        try {
            this.forgetOnRollback();
        }
        catch (IllegalStateException illegalStateException) {}
        LogWriter.out.rollback_end(this._xid, this._heuristic);
        LogWriter.out.completed(this._xid);
        if (this._parent != null) {
            this._parent.unregisterResource(new ResourceImpl(this));
        }
        if (this._sysError != null) {
            throw this._sysError;
        }
    }

    private void rollbackXAResources(XAResourceHolder[] xAResourceHolderArray) {
        int n = 0;
        while (n < xAResourceHolderArray.length) {
            XAResourceHolder xAResourceHolder = xAResourceHolderArray[n];
            try {
                if (!xAResourceHolder.shared && !xAResourceHolder.readOnly) {
                    xAResourceHolder.xa.rollback(xAResourceHolder.xid);
                    this._heuristic |= 2;
                }
            }
            catch (XAException xAException) {
                this.xaExceptionOccurred(xAException);
            }
            catch (Exception exception) {
                this._heuristic |= 0x30;
                this.error(exception);
            }
            ++n;
        }
    }

    private void securityCheck() throws SecurityException {
        if (!this._txDomain.isOwner(this.getTopLevel(), Thread.currentThread())) {
            throw new SecurityException(Messages.message("tyrex.tx.threadNotOwner"));
        }
    }

    public void setORB(ORB oRB) {
        this._orb = oRB;
    }

    public synchronized void setRollbackOnly() throws IllegalStateException, SystemException {
        switch (this._status) {
            case 0: 
            case 1: {
                this._status = 1;
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            case 4: 
            case 9: {
                return;
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
        }
    }

    public void setTransactionTimeout(int n) {
        this._txDomain.setTransactionTimeout(this, n);
    }

    private boolean shareResource(XAResource xAResource, XAResourceHolder[] xAResourceHolderArray) throws XAException, SystemException {
        if (xAResourceHolderArray != null) {
            try {
                int n = 0;
                while (n < xAResourceHolderArray.length) {
                    XAResourceHolder xAResourceHolder = xAResourceHolderArray[n];
                    if (xAResourceHolder.shared && xAResourceHolder.xa.isSameRM(xAResource)) {
                        XAResourceHolder xAResourceHolder2 = new XAResourceHolder();
                        xAResourceHolder2.xa = xAResource;
                        xAResourceHolder2.shared = true;
                        xAResourceHolder2.xid = xAResourceHolder.xid;
                        try {
                            xAResourceHolder2.xa.start(xAResourceHolder2.xid, 0x200000);
                            XAResourceHolder[] xAResourceHolderArray2 = new XAResourceHolder[this._enlisted.length + 1];
                            System.arraycopy(this._enlisted, 0, xAResourceHolderArray2, 0, this._enlisted.length);
                            xAResourceHolderArray2[this._enlisted.length] = xAResourceHolder2;
                            this._enlisted = xAResourceHolderArray2;
                            return true;
                        }
                        catch (XAException xAException) {
                            throw xAException;
                        }
                        catch (Exception exception) {
                            throw new SystemException(exception.toString());
                        }
                    }
                    ++n;
                }
            }
            catch (XAException xAException) {
                if (xAException.errorCode == -3 || xAException.errorCode == -7) {
                    throw new SystemException(xAException.toString());
                }
                throw xAException;
            }
        }
        return false;
    }

    synchronized void suspendResources() throws IllegalStateException, SystemException {
        switch (this._status) {
            case 2: 
            case 7: 
            case 8: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inCommit"));
            }
            default: {
                throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
            }
            case 0: 
            case 1: 
        }
        if (this._enlisted == null) {
            return;
        }
        XAResourceHolder xAResourceHolder = null;
        int n = 0;
        while (n < this._enlisted.length) {
            xAResourceHolder = this._enlisted[n];
            if (xAResourceHolder.endFlag == 0) {
                try {
                    xAResourceHolder.xa.end(xAResourceHolder.xid, 0x2000000);
                    xAResourceHolder.endFlag = 0x2000000;
                }
                catch (Exception exception) {
                    throw new SystemException(exception.toString());
                }
            }
            ++n;
        }
    }

    private void suspendTransaction() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                try {
                    if (TransactionImpl.this._txDomain.getTransactionManager().getTransaction() == TransactionImpl.this) {
                        TransactionImpl.this._txDomain.getTransactionManager().suspend();
                    }
                }
                catch (Exception exception) {
                    TransactionImpl.this._status = 1;
                    TransactionImpl.this.error(exception);
                }
                return null;
            }
        });
    }

    synchronized void timedOut() {
        this._timedOut = true;
        while (this._enlisted != null) {
            try {
                this.delistResource(this._enlisted[0].xa, 0x20000000);
            }
            catch (Exception exception) {}
        }
        try {
            this.internalRollback();
        }
        catch (Throwable throwable) {
            java.lang.Object var3_2 = null;
            try {
                this.forgetOnRollback();
            }
            catch (IllegalStateException illegalStateException) {}
            throw throwable;
        }
        java.lang.Object var3_1 = null;
        try {
            this.forgetOnRollback();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public String toString() {
        String string;
        switch (this._status) {
            case 0: {
                string = " (Active)";
                break;
            }
            case 1: {
                string = " (Marked for rollback)";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                string = " (Commit in progress)";
                break;
            }
            case 3: {
                string = " (Committed)";
                break;
            }
            case 4: {
                if (this._timedOut) {
                    string = " (Rolledback / Timedout)";
                    break;
                }
                string = " (Rolledback)";
                break;
            }
            case 9: {
                string = " (Rollback in progress)";
                break;
            }
            default: {
                string = " (Unknown)";
            }
        }
        return String.valueOf(this._xid.toString()) + string;
    }

    private synchronized void unregisterResource(Resource resource) {
        if (this._resources != null) {
            if (this._resources.length == 1 && this._resources[0].equals(resource)) {
                this._resources = null;
            } else {
                int n = 0;
                while (n < this._resources.length) {
                    if (this._resources[n].equals(resource)) {
                        this._resources[n] = this._resources[this._resources.length - 1];
                        Resource[] resourceArray = new Resource[this._resources.length - 1];
                        System.arraycopy(this._resources, 0, resourceArray, 0, this._resources.length - 1);
                        this._resources = resourceArray;
                    }
                    ++n;
                }
            }
        }
    }

    private void xaExceptionOccurred(XAException xAException) {
        if (xAException.errorCode == 5) {
            this._heuristic |= 4;
        } else if (xAException.errorCode == 8) {
            this._heuristic |= 8;
        } else if (xAException.errorCode != 3) {
            if (xAException.errorCode >= 100 && xAException.errorCode <= 107) {
                this._heuristic |= 2;
            } else if (xAException.errorCode == 7) {
                this._heuristic |= 1;
            } else {
                this._heuristic |= 0x20;
                this.error(xAException);
            }
        }
    }

    class XAResourceHolder {
        Xid xid;
        XAResource xa;
        int endFlag = 0;
        boolean shared;
        boolean readOnly;

        XAResourceHolder() {
        }
    }
}

