/*
 * Decompiled with CFR 0.152.
 */
package examples.ejb.basic.statefulSession;

import examples.ejb.basic.statefulSession.ProcessingErrorException;
import examples.ejb.basic.statefulSession.TradeResult;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TraderBean
implements SessionBean {
    static final boolean VERBOSE = true;
    private SessionContext ctx;
    private Context environment;
    private double tradingBalance;

    public TradeResult buy(String string, String string2, int n) throws ProcessingErrorException {
        this.log("buy (" + string + ", " + string2 + ", " + n + ")");
        double d = this.getStockPrice(string2);
        this.tradingBalance -= (double)n * d;
        return new TradeResult(n, d, 1);
    }

    public void ejbActivate() {
        this.log("ejbActivate called");
    }

    public void ejbCreate() throws CreateException {
        this.log("ejbCreate called");
        try {
            InitialContext initialContext = new InitialContext();
            this.environment = (Context)initialContext.lookup("java:comp/env");
        }
        catch (NamingException namingException) {
            throw new CreateException("Could not look up context");
        }
        this.tradingBalance = 0.0;
    }

    public void ejbPassivate() {
        this.log("ejbPassivate called");
    }

    public void ejbRemove() {
        this.log("ejbRemove called");
    }

    public double getBalance() {
        return this.tradingBalance;
    }

    public double getStockPrice(String string) throws ProcessingErrorException {
        try {
            return (Double)this.environment.lookup(string);
        }
        catch (NamingException namingException) {
            throw new ProcessingErrorException("Stock symbol " + string + " does not exist");
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProcessingErrorException("Invalid price for stock " + string);
        }
    }

    private void log(String string) {
        System.out.println(string);
    }

    public TradeResult sell(String string, String string2, int n) throws ProcessingErrorException {
        this.log("sell (" + string + ", " + string2 + ", " + n + ")");
        double d = this.getStockPrice(string2);
        this.tradingBalance += (double)n * d;
        return new TradeResult(n, d, 0);
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.log("setSessionContext called");
        this.ctx = sessionContext;
    }
}

