/*
 * Decompiled with CFR 0.152.
 */
package examples.ejb20.basic.containerManaged;

import examples.ejb20.basic.containerManaged.ProcessingErrorException;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

public abstract class AccountBean
implements EntityBean {
    static final boolean VERBOSE = true;
    private EntityContext ctx;

    public String accountType() {
        this.log("AccountBean.accountType (" + this.id() + ")");
        return this.getAccountType();
    }

    public double balance() {
        this.log("AccountBean.balance (" + this.id() + ")");
        return this.getBalance();
    }

    public double deposit(double d) {
        this.log("AccountBean.deposit: Depositing $" + d + " into '" + this.getAccountId() + "'");
        this.setBalance(this.getBalance() + d);
        return this.getBalance();
    }

    public void ejbActivate() {
        this.log("AccountBean.ejbActivate (" + this.id() + ")");
    }

    public String ejbCreate(String string, double d, String string2) throws CreateException {
        this.log("AccountBean.ejbCreate( id = " + System.identityHashCode(this) + ", PK = " + string + ", " + "initial balance = $ " + d + ")");
        this.setAccountId(string);
        this.setBalance(d);
        this.setAccountType(string2);
        return null;
    }

    public void ejbLoad() {
        this.log("AccountBean.ejbLoad (" + this.id() + ")");
    }

    public void ejbPassivate() {
        this.log("AccountBean.ejbPassivate (" + this.id() + ")");
    }

    public void ejbPostCreate(String string, double d, String string2) {
        this.log("AccountBean.ejbPostCreate (" + this.id() + ")");
    }

    public void ejbRemove() throws RemoveException {
        this.log("AccountBean.ejbRemove (" + this.id() + ")");
    }

    public void ejbStore() {
        this.log("AccountBean.ejbStore (" + this.id() + ")");
    }

    public abstract String getAccountId();

    public abstract String getAccountType();

    public abstract double getBalance();

    private String id() {
        return System.identityHashCode(this) + ", PK = " + (this.ctx == null ? "nullctx" : (this.ctx.getPrimaryKey() == null ? "null" : this.ctx.getPrimaryKey().toString()));
    }

    private void log(String string) {
        System.out.println(string);
    }

    public abstract void setAccountId(String var1);

    public abstract void setAccountType(String var1);

    public abstract void setBalance(double var1);

    public void setEntityContext(EntityContext entityContext) {
        this.log("setEntityContext called (" + this.id() + ")");
        this.ctx = entityContext;
    }

    public void unsetEntityContext() {
        this.log("AccountBean.unsetEntityContext (" + this.id() + ")");
        this.ctx = null;
    }

    public double withdraw(double d) throws ProcessingErrorException {
        this.log("AccountBean.withdraw: Withdrawing $" + d + " from '" + this.getAccountId() + "'");
        if (d > this.getBalance()) {
            throw new ProcessingErrorException("Request to withdraw $" + d + "; is more than balance $" + this.getBalance() + " in account " + this.getAccountId());
        }
        this.setBalance(this.getBalance() - d);
        return this.getBalance();
    }
}

