/*
 * Decompiled with CFR 0.152.
 */
package examples.jta.jmsjdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class ReceiveInTxBean
implements SessionBean {
    private static final boolean VERBOSE = true;
    private SessionContext ctx;

    public void ejbActivate() {
        this.log("ejbActivate called");
    }

    public void ejbCreate() throws CreateException {
        this.log("ejbCreate called");
    }

    public void ejbPassivate() {
        this.log("ejbPassivate called");
    }

    public void ejbRemove() {
        this.log("ejbRemove called");
    }

    private void log(String string) {
        System.out.println(string);
    }

    private String queueReceive(QueueReceiver queueReceiver) {
        String string = null;
        try {
            Message message = queueReceiver.receive();
            if (message != null) {
                string = message instanceof TextMessage ? ((TextMessage)message).getText() : message.toString();
                this.log("Message Received: " + string);
            }
        }
        catch (JMSException jMSException) {
            this.log("Error receiving JMS message: " + (Object)((Object)jMSException));
        }
        return string;
    }

    public void receiveMessages() {
        QueueSession queueSession;
        QueueConnection queueConnection;
        block26: {
            queueConnection = null;
            queueSession = null;
            QueueReceiver queueReceiver = null;
            Object var4_4 = null;
            try {
                try {
                    InitialContext initialContext = new InitialContext();
                    Context context = (Context)initialContext.lookup("java:comp/env");
                    String string = (String)context.lookup("queueConnFactoryName");
                    String string2 = (String)context.lookup("queueName");
                    String string3 = (String)context.lookup("xaDataSrcName");
                    String string4 = (String)context.lookup("tableName");
                    QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)initialContext.lookup(string);
                    queueConnection = queueConnectionFactory.createQueueConnection();
                    queueSession = queueConnection.createQueueSession(false, 1);
                    Queue queue = (Queue)initialContext.lookup(string2);
                    queueReceiver = queueSession.createReceiver(queue);
                    queueConnection.start();
                    DataSource dataSource = (DataSource)initialContext.lookup(string3);
                    UserTransaction userTransaction = this.ctx.getUserTransaction();
                    userTransaction.begin();
                    this.log("TRANSACTION BEGUN");
                    String string5 = null;
                    do {
                        if ((string5 = this.queueReceive(queueReceiver)).equalsIgnoreCase("quit")) {
                            userTransaction.commit();
                            this.log("TRANSACTION COMMITTED");
                            continue;
                        }
                        this.updateDatabase(dataSource, string4, string5);
                    } while (string5 != null && !string5.equals("quit"));
                }
                catch (NamingException namingException) {
                    this.log("Naming exception: " + namingException);
                }
                catch (JMSException jMSException) {
                    this.log("JMS exception: " + (Object)((Object)jMSException));
                }
                catch (NotSupportedException notSupportedException) {
                    this.log("TRANSACTION COULD NOT BEGIN DUE TO: " + (Object)((Object)notSupportedException));
                }
                catch (RollbackException rollbackException) {
                    this.log("TRANSACTION ROLLED BACK DUE TO: " + (Object)((Object)rollbackException));
                }
                catch (HeuristicRollbackException heuristicRollbackException) {
                    this.log("TRANSACTION ROLLED BACK DUE TO: " + (Object)((Object)heuristicRollbackException));
                }
                catch (HeuristicMixedException heuristicMixedException) {
                    this.log("TRANSACTION ROLLED BACK DUE TO: " + (Object)((Object)heuristicMixedException));
                }
                catch (SystemException systemException) {
                    this.log("TRANSACTION EXCEPTION: " + (Object)((Object)systemException));
                }
                Object var6_23 = null;
                if (queueReceiver == null) break block26;
            }
            catch (Throwable throwable) {
                Object var6_24 = null;
                if (queueReceiver != null) {
                    try {
                        queueReceiver.close();
                    }
                    catch (JMSException jMSException) {}
                }
                if (queueSession != null) {
                    try {
                        queueSession.close();
                    }
                    catch (JMSException jMSException) {}
                }
                if (queueConnection != null) {
                    try {
                        queueConnection.close();
                    }
                    catch (JMSException jMSException) {}
                }
                throw throwable;
            }
            try {
                queueReceiver.close();
            }
            catch (JMSException jMSException) {}
        }
        if (queueSession != null) {
            try {
                queueSession.close();
            }
            catch (JMSException jMSException) {}
        }
        if (queueConnection != null) {
            try {
                queueConnection.close();
            }
            catch (JMSException jMSException) {}
        }
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.log("setSessionContext called");
        this.ctx = sessionContext;
    }

    private void updateDatabase(DataSource dataSource, String string, String string2) {
        Connection connection;
        block13: {
            connection = null;
            Statement statement = null;
            try {
                try {
                    connection = dataSource.getConnection();
                    String string3 = "insert into " + string + " (data) values (?)";
                    statement = connection.prepareStatement(string3);
                    statement.setString(1, string2);
                    statement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    this.log("Cannot update database:" + string2);
                }
                Object var7_7 = null;
                if (statement == null) break block13;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

