/*
 * Decompiled with CFR 0.152.
 */
package examples.cluster.ejb.teller;

import examples.cluster.ejb.account.Account;
import examples.cluster.ejb.account.AccountException;
import examples.cluster.ejb.account.AccountHome;
import examples.cluster.ejb.account.AccountPK;
import examples.cluster.ejb.account.AccountResult;
import examples.cluster.ejb.teller.TellerException;
import examples.cluster.ejb.teller.TellerResult;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import weblogic.management.Admin;

public class TellerBean
implements SessionBean {
    static final boolean VERBOSE = true;
    static final int SLEEP = 3000;
    private SessionContext ctx;
    private Context rootCtx;
    private transient String serverName;
    private transient AccountHome bank;
    private transient int maxLogTableSize;
    private transient String logPoolName;

    public TellerResult balance(String string) throws TellerException, RemoteException {
        System.out.println("teller.balance called");
        return new Balance(string).transaction();
    }

    public boolean checkTransactionId(String string) throws RemoteException {
        System.out.println("teller.checkTransaction called: failover test point");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            try {
                connection = this.getDatabaseConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select transId from ejbTransLog where transId = " + string);
                while (resultSet.next()) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                throw new RemoteException(sQLException.getMessage());
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public TellerResult deposit(String string, double d, String string2) throws TellerException, RemoteException {
        System.out.println("teller.deposit called");
        return new Deposit(string, d, string2).transaction();
    }

    public void ejbActivate() {
        System.out.println("teller.ejbActivate called");
    }

    public void ejbCreate() throws CreateException {
        System.out.println("teller.ejbCreate called");
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            InitialContext initialContext = new InitialContext(properties);
            this.rootCtx = (Context)initialContext.lookup("java:comp/env");
            this.maxLogTableSize = (Integer)this.rootCtx.lookup("maxLogTableSize");
            this.logPoolName = (String)this.rootCtx.lookup("logPoolName");
        }
        catch (NamingException namingException) {
            throw new CreateException("Could not look up context");
        }
    }

    public void ejbPassivate() {
        System.out.println("teller.ejbPassivate called");
    }

    public void ejbRemove() {
        System.out.println("teller.ejbRemove called");
    }

    private Connection getDatabaseConnection() throws SQLException {
        Connection connection = null;
        try {
            Driver driver = (Driver)Class.forName("weblogic.jdbc.jts.Driver").newInstance();
            connection = driver.connect("jdbc:weblogic:jts:" + this.logPoolName, null);
        }
        catch (Exception exception) {
            System.err.println("Trouble while getting database connection");
            exception.printStackTrace();
        }
        return connection;
    }

    private String getServerName() {
        System.out.println("teller.getServerName called");
        String string = null;
        try {
            string = Admin.getServerName();
            if (string == null) {
                return "";
            }
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setSessionContext(SessionContext sessionContext) {
        System.out.println("teller.setSessionContext called");
        this.ctx = sessionContext;
        this.serverName = this.getServerName();
    }

    private void setTransactionId(String string) throws RemoteException {
        System.out.println("account.setTransactionId called");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Statement statement2 = null;
        int n = 0;
        try {
            try {
                connection = this.getDatabaseConnection();
                System.out.println("account.conn.createStatement() called");
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select count(*) from ejbTransLog");
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                Timestamp timestamp = new Timestamp(new Date().getTime());
                if (n < this.maxLogTableSize) {
                    System.out.println("account.setTransactionId: inserting record into log");
                    statement2 = connection.prepareStatement("insert into ejbTransLog values (?,?)");
                } else {
                    System.out.println("account.setTransactionId: updating record in log");
                    statement2 = connection.prepareStatement("update ejbTransLog set transId = ?, transCommitDate = ? where transCommitDate = (select min(transCommitDate) from ejbTransLog) and transId = (select min(transId) from ejbTransLog  where transCommitDate =   (select min(transCommitDate) from ejbTransLog) )");
                }
                statement2.setString(1, string);
                statement2.setTimestamp(2, timestamp);
                statement2.execute();
            }
            catch (SQLException sQLException) {
                throw new RemoteException(sQLException.getMessage());
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement2 != null) {
                statement2.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {}
    }

    public TellerResult transfer(String string, String string2, double d, String string3) throws TellerException, RemoteException {
        System.out.println("teller.transfer called");
        return new Transfer(string, string2, d, string3).transaction();
    }

    public TellerResult withdraw(String string, double d, String string2) throws TellerException, RemoteException {
        System.out.println("teller.withdraw called");
        return new Withdrawal(string, d, string2).transaction();
    }

    class Transaction {
        String transactionId;
        String account1Id;
        String account2Id;
        double amount;
        AccountPK account1PK;
        Account account1;
        AccountResult account1Result;
        AccountPK account2PK;
        Account account2;
        AccountResult account2Result;
        UserTransaction tx;

        void invokeTransaction() throws AccountException, FinderException, RemoteException {
            if (this.account1Id != null) {
                this.account1PK = new AccountPK(this.account1Id);
                this.account1 = TellerBean.this.bank.findByPrimaryKey(this.account1PK);
            }
        }

        TellerResult transaction() throws TellerException, RemoteException {
            System.out.println("teller.transaction: transactionId = " + this.transactionId);
            try {
                Properties properties = new Properties();
                InitialContext initialContext = new InitialContext(properties);
                if (TellerBean.this.bank == null) {
                    System.out.println("teller.transaction: looking up bank home");
                    TellerBean.this.bank = (AccountHome)initialContext.lookup("examples.cluster.ejb.AccountHome");
                }
                if (this.transactionId != null) {
                    this.tx = (UserTransaction)initialContext.lookup("javax.transaction.UserTransaction");
                    this.tx.begin();
                }
                this.invokeTransaction();
                if (this.transactionId != null) {
                    TellerBean.this.setTransactionId(this.transactionId);
                    System.out.println("teller.transaction: tx.commit() about to be called: failover test point");
                    Thread.sleep(3000L);
                    System.out.println("teller.transaction: calling tx.commit()");
                    this.tx.commit();
                    System.out.println("teller.transaction: tx.commit() completed: failover test point");
                    Thread.sleep(3000L);
                }
            }
            catch (Exception exception) {
                if (this.transactionId != null) {
                    try {
                        System.out.println("Rolling back transaction " + this.transactionId + " because of exception:\n" + exception.getMessage());
                        this.tx.rollback();
                    }
                    catch (Exception exception2) {
                        throw new TellerException(exception2.getMessage());
                    }
                }
                throw new RemoteException(exception.getMessage());
            }
            return new TellerResult(TellerBean.this.serverName, this.account1Result, this.account2Result);
        }

        Transaction() {
        }
    }

    class Balance
    extends Transaction {
        Balance(String string) {
            this.account1Id = string;
        }

        void invokeTransaction() throws AccountException, FinderException, RemoteException {
            super.invokeTransaction();
            this.account1Result = this.account1.balance();
        }
    }

    class Deposit
    extends Transaction {
        Deposit(String string, double d, String string2) {
            this.account1Id = string;
            this.amount = d;
            this.transactionId = string2;
        }

        void invokeTransaction() throws AccountException, FinderException, RemoteException {
            super.invokeTransaction();
            this.account1Result = this.account1.deposit(this.amount);
        }
    }

    class Withdrawal
    extends Transaction {
        Withdrawal(String string, double d, String string2) {
            this.account1Id = string;
            this.amount = d;
            this.transactionId = string2;
        }

        void invokeTransaction() throws AccountException, FinderException, RemoteException {
            super.invokeTransaction();
            this.account1Result = this.account1.withdraw(this.amount);
        }
    }

    class Transfer
    extends Transaction {
        Transfer(String string, String string2, double d, String string3) {
            this.account1Id = string;
            this.account2Id = string2;
            this.amount = d;
            this.transactionId = string3;
        }

        void invokeTransaction() throws AccountException, FinderException, RemoteException {
            super.invokeTransaction();
            if (this.account2Id != null) {
                this.account2PK = new AccountPK(this.account2Id);
                this.account2 = TellerBean.this.bank.findByPrimaryKey(this.account2PK);
                this.account1Result = this.account1.withdraw(this.amount);
                this.account2Result = this.account2.deposit(this.amount);
            }
        }
    }
}

