/*
 * Decompiled with CFR 0.152.
 */
package COM.cloudscape.ui.tabbed;

import COM.cloudscape.ui.panel.DatabasePropEditPanel;
import COM.cloudscape.ui.panel.PubItemsEditPanel;
import COM.cloudscape.ui.panel.PublicationEditPanel;
import COM.cloudscape.ui.panel.StatementsEditPanel;
import COM.cloudscape.ui.tabbed.TabbedPubEditPanel;
import c8e.ca.m_;
import c8e.cc._a;
import c8e.cc.s;
import c8e.ce.q;
import c8e.ch.l;
import c8e.ci.a;
import c8e.e.p_;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedPublicationPanel
extends TabbedPubEditPanel
implements m_ {
    s selectedPublication;
    q visualDatabasePanel;
    BorderLayout borderLayout1 = new BorderLayout();
    PublicationEditPanel publicationEditPanel = new PublicationEditPanel();
    StatementsEditPanel statementsEditPanel = new StatementsEditPanel();
    PubItemsEditPanel pubItemsEditPanel = new PubItemsEditPanel();
    DatabasePropEditPanel databasePropEditPanel = new DatabasePropEditPanel();

    public TabbedPublicationPanel() {
        try {
            this.jbInit();
            this.postInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TabbedPublicationPanel(q q2, a a2) {
        try {
            this.visualDatabasePanel = q2;
            this.jbInit();
            this.postInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        super.jbInit();
        this.getTabbedPane().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TabbedPublicationPanel.this.tabs_stateChanged(changeEvent);
            }
        });
    }

    public void postInit() {
        this.addTab(p_.getTextMessage("CV_Publ_767"), this.publicationEditPanel);
        this.addTab(p_.getTextMessage("CV_Item"), this.pubItemsEditPanel);
        this.addTab(p_.getTextMessage("CV_Prop_874"), this.databasePropEditPanel);
        this.addTab(p_.getTextMessage("CV_Sql_769"), this.statementsEditPanel);
    }

    public void setPublication(s s2) {
        this.selectedPublication = s2;
        if (this.selectedPublication == null) {
            return;
        }
        this.publicationEditPanel.setSelectedPublication(this.selectedPublication);
        this.pubItemsEditPanel.setPublication(this.selectedPublication);
        this.databasePropEditPanel.setDatabasePropHolder(this.selectedPublication);
        this.statementsEditPanel.setDomain(this.selectedPublication);
        this.setEdits(this.selectedPublication.isNew());
    }

    public void toolBarDelete() {
        this.deletePublication();
    }

    public boolean ok() {
        if (this.selectedPublication.isDeleted() || this.selectedPublication.isUnadded()) {
            return true;
        }
        if (this.save()) {
            this.publicationEditPanel.setSelectedPublication(this.selectedPublication);
            this.pubItemsEditPanel.setPublication(this.selectedPublication);
            this.statementsEditPanel.setDomain(this.selectedPublication);
            this.setEdits(false);
            this.selectedPublication.clearAllItemsVectors();
            this.visualDatabasePanel.refreshPublication(this.selectedPublication);
            this.setPublication(this.selectedPublication);
            return true;
        }
        this.setEdits(true);
        return false;
    }

    public boolean save() {
        return this.saveToDisk();
    }

    public boolean saveToDisk() {
        try {
            this.publicationEditPanel.ok();
            this.pubItemsEditPanel.saveAvailableSelections();
            this.getDomainConnection().savePublication(this.selectedPublication);
            this.databasePropEditPanel.saveToDisk();
            this.selectedPublication.resetViewColumnHolders();
            return true;
        }
        catch (Exception exception) {
            new l(this.getFrame(), exception);
            return false;
        }
    }

    public void cancel() {
        if (this.selectedPublication.isAdded()) {
            this.selectedPublication.setStatusDeleted();
            this.getVisualDatabasePanel().deletePublicationFromUI();
        } else if (this.selectedPublication.isChanged()) {
            this.selectedPublication.revertChangedStatus();
            this.databasePropEditPanel.cancel();
        }
        if (!this.selectedPublication.isDeleted() && !this.selectedPublication.isUnadded()) {
            this.selectedPublication.clearAllItemsVectors();
            this.visualDatabasePanel.refreshPublication(this.selectedPublication);
            this.setPublication(this.selectedPublication);
        }
        this.setEdits(false);
    }

    public void newPublication() {
        this.getVisualDatabasePanel().newPublication();
    }

    public void newPubTable() {
        this.getVisualDatabasePanel().newPubTable();
    }

    public void newPubView() {
        this.getVisualDatabasePanel().newPubView();
    }

    public void newPubStoredStatement() {
        this.getVisualDatabasePanel().newPubStoredStatement();
    }

    public void newPubTrigger() {
        this.getVisualDatabasePanel().newPubTrigger();
    }

    public void newPubJarFile() {
        this.getVisualDatabasePanel().newPubJarFile();
    }

    public void newPubAlias() {
        this.getVisualDatabasePanel().newPubAlias();
    }

    public void deletePublication() {
        this.getVisualDatabasePanel().deletePublication();
    }

    public void createCopyFile() {
        this.getVisualDatabasePanel().createCopyFile();
    }

    public ImageIcon getToolBarIcon() {
        return a.getPublicationWithMenu(this);
    }

    public _a getToolBarDomain() {
        return this.selectedPublication;
    }

    void tabs_stateChanged(ChangeEvent changeEvent) {
        block2: {
            Component component = this.getTabbedPane().getSelectedComponent();
            if (!(component instanceof StatementsEditPanel)) break block2;
            try {
                this.pubItemsEditPanel.saveAvailableSelections();
            }
            catch (Exception exception) {
                new l(this.getFrame(), exception);
            }
        }
    }

    public void setEdits(boolean bl2) {
        super.setEdits(bl2);
        this.publicationEditPanel.setEdits(bl2);
        this.pubItemsEditPanel.setEdits(bl2);
        this.databasePropEditPanel.selectionChanged();
    }
}

