/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jb.util;

import com.borland.jb.util.ChainedException;
import java.io.PrintStream;
import java.io.Serializable;

public class ExceptionChain
implements Serializable {
    private Exception ex;
    private ExceptionChain next;

    public static String getOriginalMessage(Exception exception) {
        Object object;
        while (exception instanceof ChainedException && (object = ((ChainedException)((Object)exception)).getExceptionChain()) != null) {
            while (((ExceptionChain)object).getNext() != null) {
                object = ((ExceptionChain)object).getNext();
            }
            exception = ((ExceptionChain)object).getException();
        }
        object = exception.getMessage();
        if (object == null || ((String)object).length() == 0 || exception instanceof ArrayIndexOutOfBoundsException) {
            String string = exception.getClass().getName();
            object = object == null ? string : String.valueOf(String.valueOf(string).concat(String.valueOf(" "))).concat(String.valueOf(object));
        }
        return object;
    }

    public Exception getException() {
        return this.ex;
    }

    public ExceptionChain getNext() {
        return this.next;
    }

    public boolean hasExceptions() {
        return this.ex != null;
    }

    private void printStackTrace(ExceptionChain exceptionChain, PrintStream printStream) {
        if (exceptionChain != null && exceptionChain.next != null) {
            exceptionChain.printStackTrace(exceptionChain.next, printStream);
        }
        if (this.ex != null) {
            this.ex.printStackTrace(printStream);
        }
    }

    public void printDiagnosticStackTrace() {
        if (this.next != null) {
            this.next.printDiagnosticStackTrace();
        }
        if (this.ex != null) {
            // empty if block
        }
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(this, printStream);
    }

    public void append(Exception exception) {
        if (this.ex == null) {
            this.ex = exception;
        } else {
            this.next = new ExceptionChain(this.next, exception);
        }
    }

    private ExceptionChain(ExceptionChain exceptionChain, Exception exception) {
        this.next = exceptionChain;
        this.ex = exception;
    }

    public ExceptionChain() {
    }
}

