/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.layout.XYLayout;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.BorderItemPainter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;
import javax.swing.UIManager;

public class BevelPanel
extends BeanPanel
implements Serializable {
    protected String textureName;
    protected Insets margins = new Insets(0, 0, 0, 0);
    protected BorderItemPainter border;
    protected boolean soft = false;
    protected int bevelOuter = 0;
    protected int bevelInner = 1;
    public static final int LOWERED = 2;
    public static final int RAISED = 1;
    public static final int FLAT = 0;

    protected void resetEdges() {
        if (this.bevelInner == 0 && this.bevelOuter == 0) {
            this.border = null;
        } else {
            int n2 = 0;
            switch (this.bevelInner) {
                case 0: {
                    break;
                }
                case 1: {
                    n2 |= 0x400;
                    break;
                }
                case 2: {
                    n2 |= 0x800;
                }
            }
            switch (this.bevelOuter) {
                case 0: {
                    break;
                }
                case 1: {
                    n2 |= 0x100;
                    break;
                }
                case 2: {
                    n2 |= 0x200;
                }
            }
            this.border = new BorderItemPainter(n2, 15, this.soft ? 4096 : 0);
        }
        this.invalidate();
        this.repaint(100L);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (this.border != null) {
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            this.border.paint(null, graphics, rectangle, 0, null);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width <= 10) {
            dimension.width = 100;
        }
        if (dimension.height <= 10) {
            dimension.height = 100;
        }
        return dimension;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        Insets insets2 = this.border != null ? this.border.getInsets() : new Insets(0, 0, 0, 0);
        return new Insets(insets.top + insets2.top + this.margins.top, insets.left + insets2.left + this.margins.left, insets.bottom + insets2.bottom + this.margins.bottom, insets.right + insets2.right + this.margins.right);
    }

    public String getTextureName() {
        return this.textureName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(Insets insets) {
        if (!this.margins.equals(insets)) {
            this.margins = insets == null ? new Insets(0, 0, 0, 0) : insets;
            this.invalidate();
            this.repaint(100L);
        }
    }

    public boolean isSoft() {
        return this.soft;
    }

    public void setSoft(boolean bl2) {
        if (bl2 != this.soft) {
            this.soft = bl2;
            this.resetEdges();
        }
    }

    public int getBevelOuter() {
        return this.bevelOuter;
    }

    public void setBevelOuter(int n2) {
        if ((n2 == 0 || n2 == 1 || n2 == 2) && n2 != this.bevelOuter) {
            this.bevelOuter = n2;
            this.resetEdges();
        }
    }

    public int getBevelInner() {
        return this.bevelInner;
    }

    public void setBevelInner(int n2) {
        if (n2 >= 0 && n2 <= 2 && n2 != this.bevelInner) {
            this.bevelInner = n2;
            this.resetEdges();
        }
    }

    public BevelPanel(int n2, int n3) {
        super.setLayout(new XYLayout());
        super.setBackground(SystemColor.control);
        super.setOpaque(true);
        if (n2 >= 0 && n2 <= 2) {
            this.bevelInner = n2;
        }
        if (n3 >= 0 && n3 <= 2) {
            this.bevelOuter = n3;
        }
        this.focusAware = false;
        this.resetEdges();
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("Panel.background"));
        super.setForeground(UIManager.getColor("Panel.foreground"));
        super.setFont(UIManager.getFont("Panel.font"));
    }

    public BevelPanel() {
        super(new XYLayout());
        super.setBackground(UIManager.getColor("Panel.background"));
        super.setForeground(UIManager.getColor("Panel.foreground"));
        super.setFont(UIManager.getFont("Panel.font"));
        super.setOpaque(true);
        this.focusAware = false;
        this.resetEdges();
    }
}

