/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jb.util.ChainedException;
import com.borland.jb.util.ExceptionChain;
import com.borland.jbcl.control.ButtonDialog;
import com.borland.jbcl.control.FieldControl;
import com.borland.jbcl.control.TextAreaControl;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.view.WrappedTextItemPainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;

public class ExceptionDialog
extends ButtonDialog
implements Serializable,
ActionListener {
    private transient Component returnFocusComponent;
    private static int showCount;
    private transient Exception ex;
    private transient Vector exceptionVector;
    private int position;
    private int detailHeight = 200;
    private boolean showDetails = false;
    private Panel centerPanel;
    private TextAreaControl details;
    private FieldControl message = new FieldControl();

    public static int getShowCount() {
        return showCount;
    }

    private void makeExceptionList(Exception exception) {
        this.exceptionVector = new Vector();
        this.exceptionVector.addElement(exception);
        if (exception instanceof ChainedException) {
            for (ExceptionChain exceptionChain = ((ChainedException)((Object)exception)).getExceptionChain(); exceptionChain != null; exceptionChain = exceptionChain.getNext()) {
                exception = exceptionChain.getException();
                this.exceptionVector.addElement(exception);
            }
        }
        this.position = 0;
    }

    private void displayException(int n2) {
        this.enableButton("previous", this.position > 0);
        this.enableButton("next", this.position < this.exceptionVector.size() - 1);
        Exception exception = (Exception)this.exceptionVector.elementAt(n2);
        String string = exception.getMessage();
        if (string == null || string.length() < 1) {
            string = exception.getClass().getName();
        }
        this.message.setText(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.flush();
        this.details.setText(byteArrayOutputStream.toString());
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.processActionEvent(new ActionEvent(this, 1001, "ok"));
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        super.processActionEvent(actionEvent);
        if (this.result != null) {
            if (this.result.closeDialog) {
                --showCount;
                if (this.returnFocusComponent != null) {
                    this.returnFocusComponent.requestFocus();
                    this.returnFocusComponent = null;
                }
            }
            if (this.result.command.equals("next") && this.position < this.exceptionVector.size() - 1) {
                this.displayException(++this.position);
            }
            if (this.result.command.equals("previous") && this.position > 0) {
                this.displayException(--this.position);
            }
            if (this.result.command.equals("details")) {
                if (!this.showDetails) {
                    Dimension dimension = this.getSize();
                    Rectangle rectangle = this.centerPanel.getBounds();
                    ((Container)this).remove(this.centerPanel);
                    this.getContentPane().add((Component)this.centerPanel, "North");
                    this.getContentPane().add((Component)this.details, "Center");
                    this.details.setBounds(rectangle.x, rectangle.y + rectangle.height, rectangle.width, this.detailHeight);
                    ((Component)this).setSize(dimension.width, dimension.height + this.detailHeight);
                } else {
                    Dimension dimension = this.getSize();
                    this.detailHeight = this.details.getSize().height;
                    ((Container)this).remove(this.details);
                    ((Container)this).remove(this.centerPanel);
                    this.getContentPane().add((Component)this.centerPanel, "Center");
                    ((Component)this).setSize(dimension.width, dimension.height - this.detailHeight);
                }
                this.showDetails = !this.showDetails;
            }
        }
    }

    public ExceptionDialog(Frame frame, String string, Exception exception, boolean bl2, Component component) {
        this(frame, string, exception, bl2);
        this.returnFocusComponent = component;
    }

    public ExceptionDialog(Frame frame, String string, Exception exception, Component component) {
        this(frame, string, exception, false);
        this.returnFocusComponent = component;
    }

    public ExceptionDialog(Frame frame, String string, Exception exception) {
        this(frame, string, exception, false);
    }

    public ExceptionDialog(Frame frame, String string, Exception exception, boolean bl2) {
        super(frame, string, bl2, null, null, ButtonDialog.buttonSetToButtonDescriptors(ExceptionDialog.makeButtonSet(exception)));
        this.details = new TextAreaControl();
        this.centerPanel = new Panel();
        this.ex = exception;
        this.details.setEditable(false);
        ((Component)this.details).setBackground(SystemColor.window);
        this.details.setPreferredHeight(200);
        this.message.setPreferredHeight(100);
        this.message.setPreferredWidth(400);
        this.message.setModel(new BasicSingletonContainer());
        this.message.setAlignment(1);
        this.message.setViewManager(new BasicViewManager(new WrappedTextItemPainter(null, 1, 0), null));
        this.makeExceptionList(exception);
        this.getContentPane().setLayout(new BorderLayout());
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.message, "Center");
        this.centerPanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        ((Component)this).setBackground(SystemColor.control);
        this.pack();
        this.setEnterOK(true);
        this.displayException(0);
        ++showCount;
    }

    private static int makeButtonSet(Exception exception) {
        if (exception instanceof ChainedException && ((ChainedException)((Object)exception)).getExceptionChain() != null) {
            return 897;
        }
        return 513;
    }
}

