/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.jb.util.VetoException;
import com.borland.jbcl.control.ListControl$1;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicVectorContainer;
import com.borland.jbcl.model.BasicVectorSelection;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingleVectorSelection;
import com.borland.jbcl.model.VectorDataSetManager;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorSubfocusEvent;
import com.borland.jbcl.model.VectorSubfocusListener;
import com.borland.jbcl.model.WritableVectorModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.ListView;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.TextItemEditor;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.io.Serializable;

public class ListControl
extends ListView
implements Serializable,
ColumnAware,
BlackBox,
VectorModel,
VectorSubfocusListener,
AccessListener,
DataChangeListener,
NavigationListener {
    protected String textureName;
    protected int topIndex = -1;
    protected boolean autoInsert = true;
    protected boolean addNotifyCalled = false;
    protected boolean multiSelect = false;
    protected boolean dsNavigating = false;
    protected boolean userSetNavigate = true;
    protected boolean navigateDataSet = false;
    protected String columnName;
    protected DataSet dataSet;

    public void enableModelEvents(boolean bl2) {
        WritableVectorModel writableVectorModel = this.getWriteModel();
        if (writableVectorModel != null && writableVectorModel.isVariableSize()) {
            writableVectorModel.enableModelEvents(bl2);
        }
    }

    public void removeAllItems() {
        WritableVectorModel writableVectorModel = this.getWriteModel();
        if (writableVectorModel != null && writableVectorModel.isVariableSize()) {
            writableVectorModel.removeAll();
        }
    }

    public void removeAll() {
        super.removeAll();
    }

    public void removeItem(int n2) {
        WritableVectorModel writableVectorModel = this.getWriteModel();
        if (writableVectorModel != null && writableVectorModel.isVariableSize() && writableVectorModel.getCount() > n2) {
            writableVectorModel.remove(n2);
        }
    }

    public void remove(int n2) {
        super.remove(n2);
    }

    public void addItem(int n2, Object object) {
        WritableVectorModel writableVectorModel = this.getWriteModel();
        if (writableVectorModel != null && writableVectorModel.isVariableSize() && writableVectorModel.getCount() >= n2) {
            writableVectorModel.addItem(n2, object);
        }
    }

    public void addItem(Object object) {
        WritableVectorModel writableVectorModel = this.getWriteModel();
        if (writableVectorModel != null && writableVectorModel.isVariableSize()) {
            writableVectorModel.addItem(object);
        }
    }

    public boolean isVariableSize() {
        WritableVectorModel writableVectorModel = this.getWriteModel();
        return writableVectorModel != null && writableVectorModel.isVariableSize();
    }

    public void touched(int n2) {
        WritableVectorModel writableVectorModel = this.getWriteModel();
        if (writableVectorModel != null) {
            writableVectorModel.touched(n2);
        }
    }

    public void set(int n2, Object object) {
        WritableVectorModel writableVectorModel = this.getWriteModel();
        if (writableVectorModel != null && writableVectorModel.canSet(n2, true)) {
            writableVectorModel.set(n2, object);
        }
    }

    public boolean canSet(int n2, boolean bl2) {
        WritableVectorModel writableVectorModel = this.getWriteModel();
        return writableVectorModel != null && writableVectorModel.canSet(n2, bl2);
    }

    public int getCount() {
        return this.getModel().getCount();
    }

    public int find(Object object) {
        return this.getModel().find(object);
    }

    public Object get(int n2) {
        return this.getModel().get(n2);
    }

    private void bindProperties(Column column) {
        Color color = column.getBackground();
        Color color2 = column.getForeground();
        Font font = column.getFont();
        int n2 = column.getAlignment();
        if (color != null) {
            this.setBackground(color);
        }
        if (color2 != null) {
            this.setForeground(color2);
        }
        if (font != null) {
            this.setFont(font);
        }
        if (n2 != 0) {
            this.setAlignment(n2);
        }
    }

    private boolean bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setBatchMode(true);
            VectorDataSetManager vectorDataSetManager = new VectorDataSetManager(this.dataSet, column, this);
            super.setModel(vectorDataSetManager);
            super.setViewManager(vectorDataSetManager);
            this.navigateDataSet = true;
            this.resetSelection();
            this.bindProperties(column);
            if (this.topIndex > -1) {
                super.setTopIndex(this.topIndex);
                this.topIndex = -1;
            }
            if (this.isShowing() && !this.isBatchMode()) {
                this.doLayout();
            }
            this.setBatchMode(false);
            return true;
        }
        this.buildStringList(this.getItems());
        return false;
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.buildStringList(null);
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.dataSet, this, dataSetException);
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    public void setColumnName(String string) {
        this.columnName = string;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeDataChangeListener(this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addDataChangeListener(this);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setItems(DataSet dataSet, String string) {
        if (dataSet != null && string != null) {
            try {
                DataSetView dataSetView = dataSet.cloneDataSetView();
                dataSetView.open();
                dataSetView.first();
                String[] stringArray = new String[dataSetView.getRowCount()];
                int n2 = 0;
                while (dataSetView.inBounds()) {
                    stringArray[n2++] = dataSetView.getString(string);
                    dataSetView.next();
                }
                this.setItems(stringArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        this.endEdit();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
    }

    public void navigated(NavigationEvent navigationEvent) {
        if (!this.dsNavigating && this.userSetNavigate && this.navigateDataSet && this.getSubfocus() != this.dataSet.getRow()) {
            this.setSubfocus(this.dataSet.getRow());
        }
    }

    public void subfocusChanged(VectorSubfocusEvent vectorSubfocusEvent) {
    }

    public void subfocusChanging(VectorSubfocusEvent vectorSubfocusEvent) throws VetoException {
        if (this.dataSet != null && this.dataSet.isOpen() && this.userSetNavigate && this.navigateDataSet) {
            if (this.dataSet.getRow() != vectorSubfocusEvent.getLocation()) {
                try {
                    this.dsNavigating = true;
                    if (!this.dataSet.goToRow(vectorSubfocusEvent.getLocation())) {
                        this.dsNavigating = false;
                        throw new VetoException();
                    }
                }
                catch (DataSetException dataSetException) {
                    DataSetModel.handleException(this.dataSet, this, dataSetException);
                    this.dsNavigating = false;
                    throw new VetoException();
                }
            }
            this.dsNavigating = false;
        }
    }

    public boolean isNavigateWithDataSet() {
        return this.userSetNavigate;
    }

    public void setNavigateWithDataSet(boolean bl2) {
        this.userSetNavigate = bl2;
        if (this.userSetNavigate && this.navigateDataSet && this.dataSet != null && this.dataSet.isOpen()) {
            this.setSubfocus(this.dataSet.getRow());
        }
    }

    private void resetSelection() {
        if (this.multiSelect) {
            int[] nArray = this.getSelection().getAll();
            this.setSelection(new BasicVectorSelection());
            this.getSelection().add(nArray);
        } else {
            this.setSelection(new SingleVectorSelection());
            this.getSelection().add(this.getSubfocus());
        }
        this.repaint(50L);
    }

    public boolean isAutoInsert() {
        return this.autoInsert;
    }

    public void setAutoInsert(boolean bl2) {
        this.autoInsert = bl2;
    }

    public void setMultiSelect(boolean bl2) {
        this.multiSelect = bl2;
        this.resetSelection();
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                this.safeEndEdit(false);
                this.buildStringList(null);
                break;
            }
        }
    }

    public void setTopIndex(int n2) {
        if (!this.addNotifyCalled) {
            this.topIndex = n2;
        } else {
            super.setTopIndex(n2);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
        if (this.topIndex > -1) {
            super.setTopIndex(this.topIndex);
            this.topIndex = -1;
        }
    }

    private void buildStringList(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.navigateDataSet = false;
        super.setModel(new BasicVectorContainer(stringArray));
        super.setViewManager(new BasicViewManager(new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter())), new TextItemEditor()));
        this.resetSelection();
        if (this.isShowing() && !this.isBatchMode()) {
            this.doLayout();
        }
        if (this.topIndex > -1) {
            super.setTopIndex(this.topIndex);
            this.topIndex = -1;
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public synchronized void setItems(String[] stringArray) {
        if (this.getModel() instanceof VectorDataSetManager) {
            throw new IllegalStateException(Res.getString(75));
        }
        this.buildStringList(stringArray);
    }

    public synchronized String[] getItems() {
        VectorModel vectorModel = this.getModel();
        if (vectorModel == null || vectorModel instanceof VectorDataSetManager) {
            return new String[0];
        }
        int n2 = vectorModel.getCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = vectorModel.get(i2);
            stringArray[i2] = object != null ? object.toString() : "";
        }
        return stringArray;
    }

    public void setModel(VectorModel vectorModel) {
        if (vectorModel == this) {
            throw new IllegalArgumentException(Res.getString(76));
        }
        super.setModel(vectorModel);
    }

    public ListControl() {
        this.buildStringList(null);
        this.addFocusListener(new ListControl$1(this));
        this.addSubfocusListener(this);
    }
}

