/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.ColumnVariant;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.ValidationException;
import com.borland.dx.dataset.Variant;
import com.borland.dx.text.InvalidFormatException;
import com.borland.dx.text.ItemEditMask;
import com.borland.dx.text.ItemEditMaskState;
import com.borland.dx.text.ItemEditMaskStr;
import com.borland.dx.text.ItemFormatter;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Hashtable;
import java.util.Locale;

public class MaskableTextItemEditor
extends TextField
implements Serializable,
ItemEditor {
    int dataType;
    int alignment = 33;
    transient ItemFormatter formatter;
    boolean allSelected;
    boolean changed;
    private transient Object startingValue;
    private String startingText;
    private DataSet ds;
    private boolean editingNow;
    private boolean hookedEvents;
    private ItemEditMaskState state;
    private transient ItemEditMask ems;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v2 = hashtable.get("e");
        if (v2 instanceof ItemEditMask) {
            this.ems = (ItemEditMask)v2;
        }
        if ((v2 = hashtable.get("f")) instanceof ItemFormatter) {
            this.formatter = (ItemFormatter)v2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        if (this.ems instanceof Serializable) {
            hashtable.put("e", this.ems);
        }
        if (this.formatter instanceof Serializable) {
            hashtable.put("f", this.formatter);
        }
        objectOutputStream.writeObject(hashtable);
    }

    public ItemFormatter getFormatter() {
        return this.formatter;
    }

    private void hookEvents() {
        if (!this.hookedEvents) {
            this.enableEvents(60L);
            this.hookedEvents = true;
        }
    }

    private void handleMouseClicked(MouseEvent mouseEvent) {
        int n2;
        Point point = mouseEvent.getPoint();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int[] nArray = fontMetrics.getWidths();
        int n3 = point.x;
        String string = this.state.displayString.toString();
        int n4 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            int n5;
            int n6 = string.charAt(n2) < '\u0100' ? nArray[string.charAt(n2)] : fontMetrics.charWidth(string.charAt(n2));
            int n7 = n5 = n6 > 3 ? n6 / 3 : 1;
            if (n4 + n5 >= n3) {
                --n2;
                break;
            }
            if (n4 + n6 - n5 >= n3) break;
            n4 += n6;
        }
        this.state.cursorPos = n2;
        this.ems.move(this.state, 500);
        this.updateSelection();
    }

    private void handleKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        int n3 = keyEvent.getKeyCode();
        if (n2 != 401 && n2 != 400) {
            return;
        }
        this.allSelected = false;
        switch (n3) {
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                this.ems.move(this.state, n3);
                this.updateSelection();
                break;
            }
            case 8: {
                if (!this.ems.move(this.state, 37)) break;
                this.updateSelection();
                this.deleteSelection(false);
                this.updateDisplay();
                break;
            }
            case 127: {
                this.deleteSelection(false);
                this.ems.move(this.state, 39);
                this.updateDisplay();
                break;
            }
            case 9: 
            case 10: {
                if (n2 != 400) {
                    return;
                }
                this.canPost();
                break;
            }
            case 27: {
                this.startEdit(this.startingValue, null, null);
                this.changed = false;
                break;
            }
            default: {
                char c2 = keyEvent.getKeyChar();
                if (n2 != 400 || c2 >= '\u0000' && c2 < ' ') {
                    return;
                }
                this.deleteSelection(true);
                this.ems.insert(this.state, c2);
                this.updateDisplay();
            }
        }
        keyEvent.consume();
    }

    void deleteSelection(boolean bl2) {
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        int n4 = n3 - n2;
        if (n4 < 0) {
            n2 = n3;
            n4 = -n4;
        }
        if (n4 > 1 || !bl2) {
            this.ems.delete(this.state, n2, n4);
        }
        this.allSelected = false;
        this.changed = true;
    }

    void updateDisplay() {
        if (this.state != null) {
            this.setText(this.state.displayString.toString());
            this.updateSelection();
        }
    }

    void updateSelection() {
        if (this.state != null) {
            if (this.allSelected) {
                this.select(0, this.state.displayString.toString().length());
            } else {
                this.select(this.state.cursorPos, this.state.cursorPos + 1);
            }
        }
    }

    void maskControl_gotFocus() {
        if (this.hookedEvents && this.state == null) {
            this.startEdit(null, null, null);
        }
        this.updateSelection();
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.hookedEvents && this.ems != null && mouseEvent.getID() == 502) {
            this.updateSelection();
        } else if (this.hookedEvents && this.ems != null && mouseEvent.getID() == 500) {
            this.handleMouseClicked(mouseEvent);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this.maskControl_gotFocus();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.hookedEvents) {
            this.handleKeyEvent(keyEvent);
        }
        super.processKeyEvent(keyEvent);
    }

    public void setEditMasker(ItemEditMask itemEditMask) {
        this.ems = itemEditMask;
        this.state = null;
        if (this.ems != null) {
            this.hookEvents();
        }
        if (this.editingNow) {
            this.startEdit(null, null, null);
        }
    }

    public void setEditMask(String string, int n2, Locale locale) {
        this.setEditMasker(new ItemEditMaskStr(string, null, n2, locale));
    }

    public void endEdit(boolean bl2) {
        this.editingNow = false;
        this.startingValue = null;
        this.startingText = null;
        this.changed = false;
    }

    public boolean canPost() {
        if (this.ems == null) {
            if (this.formatter == null) {
                return true;
            }
            String string = this.getText();
            if (this.startingText != null && string.equals(this.startingText)) {
                return true;
            }
            try {
                this.formatter.parse(string);
            }
            catch (Exception exception) {
                this.handleException(exception);
                boolean bl2 = false;
                return bl2;
            }
            return true;
        }
        String string = null;
        if (!this.changed) {
            return true;
        }
        boolean bl3 = false;
        try {
            bl3 = this.ems.isComplete(this.state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateSelection();
        if (bl3) {
            try {
                this.ems.getFinalValue(this.state, new Variant());
            }
            catch (Exception exception) {
                if (exception instanceof InvalidFormatException) {
                    string = exception.getMessage();
                }
                bl3 = false;
            }
        }
        if (!bl3 && this.ds != null) {
            if (string == null) {
                string = Res.getString(74);
            }
            this.handleException(new InvalidFormatException(string));
        }
        return bl3;
    }

    private void handleException(Exception exception) {
        try {
            ValidationException.invalidFormat(exception, null, null);
        }
        catch (ValidationException validationException) {
            DataSetModel.handleException(this.ds, this, validationException);
        }
    }

    public void changeBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void startEdit(Object object, Rectangle rectangle, ItemEditSite itemEditSite) {
        int n2;
        Object object2;
        Object object3;
        block28: {
            if (object != null && object != this.startingValue && object instanceof Variant) {
                this.startingValue = new Variant();
                ((Variant)this.startingValue).setVariant((Variant)object);
            } else {
                this.startingValue = object;
            }
            this.startingText = null;
            this.changed = false;
            DataSet dataSet = this.ds = object != null && object instanceof ColumnVariant ? ((ColumnVariant)object).getDataSet() : null;
            if (this.ems == null) {
                try {
                    if (object == null) {
                        this.setText("");
                        break block28;
                    }
                    if (this.formatter != null && object instanceof Variant) {
                        object3 = this.formatter.getPattern();
                        object2 = null;
                        if (this.ems == null && object != null && object instanceof ColumnVariant && ((ColumnVariant)object).getColumn().getDisplayMask() == null && this.formatter.getFormatObj() != null && this.formatter.getFormatObj() instanceof DateFormat) {
                            n2 = -1;
                            n2 = ((String)object3).indexOf(121);
                            if (n2 != -1) {
                                int n3 = 1;
                                int n4 = ((String)object3).length();
                                while (n2 + n3 < n4 && ((String)object3).charAt(n2 + n3) == 'y') {
                                    ++n3;
                                }
                                if (n3 < 4) {
                                    object2 = String.valueOf(String.valueOf(((String)object3).substring(0, n2)).concat(String.valueOf("yyyy"))).concat(String.valueOf(n2 + n3 < n4 ? ((String)object3).substring(n2 + n3) : ""));
                                    System.out.println(String.valueOf("widePattern: ").concat(String.valueOf(object2)));
                                }
                            }
                        }
                        if (object2 != null) {
                            this.formatter.setPattern((String)object2);
                        }
                        this.setText(this.formatter.format(object));
                        if (object2 != null) {
                            this.formatter.setPattern((String)object3);
                        }
                        break block28;
                    }
                    this.setText(object.toString());
                }
                catch (Exception exception) {
                    this.setText("");
                }
            } else {
                if (object == null || !(object instanceof Variant)) {
                    object3 = new Variant();
                    if (object == null) {
                        ((Variant)object3).setNull(1);
                    } else {
                        ((Variant)object3).setString(object.toString());
                    }
                    object = object3;
                }
                this.state = this.ems.prepare((Variant)object);
                this.allSelected = true;
                this.updateDisplay();
            }
        }
        this.editingNow = true;
        this.startingText = this.getText();
        if (rectangle != null) {
            this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (itemEditSite != null) {
            ((Component)this).setBackground(itemEditSite.getBackground());
            this.setForeground(itemEditSite.getForeground());
            this.setFont(itemEditSite.getFont());
        }
        this.setVisible(true);
        object3 = this.getText();
        object2 = itemEditSite != null ? itemEditSite.getEditClickPoint() : null;
        n2 = 0;
        if (object2 == null && object3 != null) {
            n2 = this.state == null ? ((String)object3).length() : this.state.cursorPos;
        } else if (object3 != null) {
            int n5;
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            int[] nArray = fontMetrics.getWidths();
            int n6 = ((Point)object2).x - rectangle.x;
            int n7 = 0;
            for (n5 = 0; n5 < ((String)object3).length(); ++n5) {
                int n8;
                int n9 = ((String)object3).charAt(n5) < '\u0100' ? nArray[((String)object3).charAt(n5)] : fontMetrics.charWidth(((String)object3).charAt(n5));
                int n10 = n8 = n9 > 3 ? n9 / 3 : 1;
                if (n7 + n8 >= n6) {
                    --n5;
                    break;
                }
                if (n7 + n9 - n8 >= n6) break;
                n7 += n9;
            }
            n2 = n5;
        }
        if (this.ems == null) {
            if (object2 != null) {
                this.select(n2, n2);
            } else {
                this.select(0, n2);
            }
        } else {
            this.state.cursorPos = n2;
            this.ems.move(this.state, 501);
            this.updateDisplay();
        }
        this.requestFocus();
    }

    public Component getComponent() {
        return this;
    }

    public Object getValue() {
        Variant variant = new Variant();
        if (this.ems == null) {
            String string = this.getText();
            if (this.startingText != null && string.equals(this.startingText)) {
                return this.startingValue;
            }
            if (this.formatter != null) {
                try {
                    variant = (Variant)this.formatter.parse(string);
                }
                catch (Exception exception) {
                    if (exception instanceof InvalidFormatException) {
                        this.state.cursorPos = ((InvalidFormatException)exception).getErrorOffset();
                    }
                    this.updateSelection();
                    if (this.ds != null) {
                        this.handleException(exception);
                    }
                    throw new IllegalStateException();
                }
                return variant;
            }
            variant.setString(string);
            return variant;
        }
        if (!this.changed) {
            return this.startingValue;
        }
        try {
            this.ems.getFinalValue(this.state, variant);
            Variant variant2 = variant;
            return variant2;
        }
        catch (Exception exception) {
            if (exception instanceof InvalidFormatException) {
                this.state.cursorPos = ((InvalidFormatException)exception).getErrorOffset();
            }
            this.updateSelection();
            if (this.ds != null) {
                this.handleException(exception);
            }
            throw new IllegalStateException();
        }
    }

    public MaskableTextItemEditor(int n2, Insets insets, ItemFormatter itemFormatter, ItemEditMask itemEditMask) {
        this();
        this.alignment = n2;
        this.formatter = itemFormatter;
        this.setEditMasker(itemEditMask);
    }

    public MaskableTextItemEditor(ItemFormatter itemFormatter, ItemEditMask itemEditMask) {
        this();
        this.formatter = itemFormatter;
        this.setEditMasker(itemEditMask);
    }

    public MaskableTextItemEditor(int n2, Insets insets) {
        this(n2, insets, null, null);
    }

    public MaskableTextItemEditor() {
    }
}

