/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.util.BlackBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;

public class ShapeControl
extends JComponent
implements BlackBox,
Serializable {
    private boolean fill = true;
    private boolean drawEdge = true;
    private Color edgeColor = Color.black;
    private int type = 0;
    public static final int NEG_SLOPE_LINE = 9;
    public static final int POS_SLOPE_LINE = 8;
    public static final int VERT_LINE = 7;
    public static final int HORZ_LINE = 6;
    public static final int CIRCLE = 5;
    public static final int ELLIPSE = 4;
    public static final int ROUND_SQUARE = 3;
    public static final int SQUARE = 2;
    public static final int ROUND_RECT = 1;
    public static final int RECTANGLE = 0;

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public void paintComponent(Graphics graphics) {
        int n2;
        super.paintComponent(graphics);
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getSize().width;
        int n6 = this.getSize().height;
        int n7 = n2 = n5 < n6 ? n5 : n6;
        if (this.type == 2 || this.type == 3 || this.type == 5) {
            n3 += (n5 - n2) / 2;
            n4 += (n6 - n2) / 2;
            n5 = n2;
            n6 = n2;
        }
        switch (this.type) {
            case 0: 
            case 2: {
                if (this.fill) {
                    graphics.setColor(this.getForeground());
                    graphics.fillRect(n3, n4, n5, n6);
                }
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawRect(n3, n4, n5 - 1, n6 - 1);
                break;
            }
            case 1: 
            case 3: {
                if (this.fill) {
                    graphics.setColor(this.getForeground());
                    graphics.fillRoundRect(n3, n4, n5, n6, n2 / 4, n2 / 4);
                }
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawRoundRect(n3, n4, n5 - 1, n6 - 1, n2 / 4, n2 / 4);
                break;
            }
            case 4: 
            case 5: {
                if (this.fill) {
                    graphics.setColor(this.getForeground());
                    graphics.fillOval(n3, n4, n5, n6);
                }
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawOval(n3, n4, n5 - 1, n6 - 1);
                break;
            }
            case 6: {
                graphics.setColor(this.getForeground());
                graphics.drawLine(n3, n4, n3 + n5, n4);
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawLine(n3, n4 + 1, n3 + n5, n4 + 1);
                break;
            }
            case 7: {
                graphics.setColor(this.getForeground());
                graphics.drawLine(n3, n4, n3, n4 + n6);
                if (!this.drawEdge) break;
                graphics.setColor(this.edgeColor);
                graphics.drawLine(n3 + 1, n4, n3 + 1, n4 + n6);
                break;
            }
            case 8: {
                if (this.drawEdge) {
                    graphics.setColor(this.edgeColor);
                    graphics.drawLine(n3, n4 + 1 + n6, n3 + n5, n4 + 1);
                }
                graphics.setColor(this.getForeground());
                graphics.drawLine(n3, n4 + n6, n3 + n5, n4);
                break;
            }
            case 9: {
                if (this.drawEdge) {
                    graphics.setColor(this.edgeColor);
                    graphics.drawLine(n3, n4 + 1, n3 + n5, n4 + n6 + 1);
                }
                graphics.setColor(this.getForeground());
                graphics.drawLine(n3, n4, n3 + n5, n4 + n6);
            }
        }
    }

    public boolean isDrawEdge() {
        return this.drawEdge;
    }

    public void setDrawEdge(boolean bl2) {
        this.drawEdge = bl2;
        this.repaint(100L);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color color) {
        this.edgeColor = color;
        this.repaint(100L);
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean bl2) {
        this.fill = bl2;
        this.repaint(100L);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n2) {
        if (this.type != n2) {
            this.type = n2;
            this.repaint(100L);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint(100L);
    }

    public ShapeControl(int n2) {
        this();
        this.setType(n2);
    }

    public ShapeControl() {
        this.setSize(100, 100);
        super.setForeground(Color.white);
    }
}

