/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.layout.PaneLayout;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.BeanPanel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class SplitPanel
extends BeanPanel
implements Serializable,
MouseMotionListener,
MouseListener {
    String textureName;
    transient Component[] enabledComponents;
    transient Rectangle bounds;
    boolean mouseOverPanel = false;
    boolean isSizing = false;
    Rectangle dividerBounds;
    Rectangle dividerRect;
    int yDelta;
    int xDelta;
    boolean yChanges;
    Cursor cursor;
    Canvas paneLayoutDivider;
    PaneLayout layout = new PaneLayout();

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width == 10) {
            dimension.width = 100;
        }
        if (dimension.height == 10) {
            dimension.height = 100;
        }
        return dimension;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isSizing) {
            int n2 = this.dividerRect.x;
            int n3 = this.dividerRect.y;
            int n4 = mouseEvent.getY();
            int n5 = mouseEvent.getX();
            if (n4 <= this.bounds.y || n4 >= this.bounds.y + this.bounds.height) {
                return;
            }
            if (n5 <= this.bounds.x || n5 >= this.bounds.x + this.bounds.width) {
                return;
            }
            if (this.yChanges) {
                n3 = n4 - this.yDelta;
                if (n3 < this.dividerBounds.y) {
                    n3 = this.dividerBounds.y;
                } else if (n3 > this.dividerBounds.height + this.dividerBounds.y - 1) {
                    n3 = this.dividerBounds.height + this.dividerBounds.y - 1;
                }
            } else {
                n2 = n5 - this.xDelta;
                if (n2 > this.dividerBounds.width + this.dividerBounds.x - 1) {
                    n2 = this.dividerBounds.width + this.dividerBounds.x - 1;
                } else if (n2 < this.dividerBounds.x) {
                    n2 = this.dividerBounds.x;
                }
            }
            this.layout.dragDivider(n2, n3);
            this.dividerRect.x = n2;
            this.dividerRect.y = n3;
            this.paneLayoutDivider.setLocation(n2, n3);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.isSizing = false;
        if (mouseEvent.getComponent() != this) {
            return;
        }
        Rectangle rectangle = this.layout.getDividerRect(mouseEvent.getX(), mouseEvent.getY());
        if (rectangle != null) {
            if (rectangle.width > rectangle.height) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOverPanel = true;
        if (!this.isSizing) {
            this.cursor = this.getCursor();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOverPanel = false;
        if (this.cursor != null && !this.isSizing) {
            this.setCursor(this.cursor);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.paneLayoutDivider.setVisible(false);
        if (this.isSizing) {
            this.isSizing = false;
            for (int i2 = 0; i2 < this.enabledComponents.length; ++i2) {
                if (this.enabledComponents[i2] == null) continue;
                this.enabledComponents[i2].setEnabled(true);
            }
            this.setCursor(this.cursor);
        }
        this.validate();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() != this || !this.mouseOverPanel) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this.mouseOverPanel) {
            this.dividerRect = this.layout.getDividerRect(n2, n3);
        }
        if (this.dividerRect != null) {
            this.dividerBounds = this.layout.getDividerBounds();
            if (this.dividerRect.width > this.dividerRect.height) {
                this.yChanges = true;
                this.yDelta = n3 - this.dividerRect.y;
            } else {
                this.yChanges = false;
                this.xDelta = n2 - this.dividerRect.x;
            }
            this.isSizing = true;
            this.bounds = this.getBounds();
            Component[] componentArray = this.getComponents();
            this.enabledComponents = new Component[componentArray.length];
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!componentArray[i2].isEnabled()) continue;
                this.enabledComponents[i2] = componentArray[i2];
                componentArray[i2].setEnabled(false);
            }
            this.add((Component)this.paneLayoutDivider, 0);
            this.paneLayoutDivider.setBounds(this.dividerRect.x, this.dividerRect.y, this.dividerRect.width, this.dividerRect.height);
            this.paneLayoutDivider.setVisible(true);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof PaneLayout) {
            this.layout = (PaneLayout)layoutManager;
            super.setLayout(layoutManager);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public Color getDividerColor() {
        return this.paneLayoutDivider.getBackground();
    }

    public void setDividerColor(Color color) {
        this.paneLayoutDivider.setBackground(color);
    }

    public int getGap() {
        return this.layout.getGap();
    }

    public void setGap(int n2) {
        this.layout.setGap(n2);
    }

    public SplitPanel() {
        super(null);
        this.paneLayoutDivider = new Canvas();
        this.setFocusAware(false);
        this.paneLayoutDivider.setName("SplitPanel.splitter");
        this.add(this.paneLayoutDivider);
        this.paneLayoutDivider.setVisible(false);
        this.paneLayoutDivider.setEnabled(false);
        this.setDividerColor(Color.black);
        this.layout.setGap(2);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        super.setLayout(this.layout);
    }
}

