/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.StatusEvent;
import com.borland.dx.dataset.StatusListener;
import com.borland.jbcl.control.BevelPanel;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.control.TextControl;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.util.BlackBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class StatusBar
extends BevelPanel
implements Serializable,
BlackBox,
DataSetAware,
AccessListener,
StatusListener,
NavigationListener {
    private boolean addNotifyCalled = false;
    protected TextControl label = new TextControl();
    protected DataSet dataSet;

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 200) {
            dimension.width = 200;
        }
        return dimension;
    }

    public String toString() {
        return this.getText();
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.removeMouseMotionListener(mouseMotionListener);
        this.label.removeMouseMotionListener(mouseMotionListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        this.label.addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.label.removeMouseListener(mouseListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.label.addMouseListener(mouseListener);
    }

    protected void updateValue() {
        if (this.dataSet != null && this.dataSet.isOpen()) {
            try {
                if (this.dataSet.getRowCount() > 0) {
                    this.setText(Res.format(19, Integer.toString(this.dataSet.getRow() + 1), Integer.toString(this.dataSet.getRowCount())));
                } else if (this.dataSet.isEnableInsert() && !this.dataSet.getStorageDataSet().isReadOnly()) {
                    this.setText(Res.getString(20));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.updateValue();
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                this.updateValue();
                break;
            }
            case 2: {
                this.setText("");
                break;
            }
        }
    }

    public void statusMessage(StatusEvent statusEvent) {
        this.setText(statusEvent.getMessage());
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetModel.handleException(this.dataSet, this, dataSetException);
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.updateValue();
        }
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeStatusListener(this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addStatusListener(this);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setAlignment(int n2) {
        this.label.setAlignment(n2);
    }

    public int getAlignment() {
        return this.label.getAlignment();
    }

    public StatusBar() {
        this.setLayout(new BorderLayout());
        this.setMargins(new Insets(0, 2, 0, 2));
        this.add((Component)this.label, "Center");
    }
}

