/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;

public class ColumnMatrixSelection
implements Serializable,
WritableMatrixSelection {
    private boolean events = true;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private int rows;
    private int cellColumn = -1;

    protected void processSelectionEvent(MatrixSelectionEvent matrixSelectionEvent) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch(matrixSelectionEvent);
        }
    }

    public void enableSelectionEvents(boolean bl2) {
        this.events = bl2;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.cellColumn != -1) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void removeRange(int n2, int n3, int n4, int n5) {
        if (this.cellColumn != -1 && this.cellColumn >= n3 && this.cellColumn <= n5) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        this.removeRange(matrixLocation.row, matrixLocation.column, matrixLocation2.row, matrixLocation2.column);
    }

    public void remove(MatrixLocation[] matrixLocationArray) {
        if (this.cellColumn != -1) {
            for (int i2 = 0; i2 < matrixLocationArray.length; ++i2) {
                if (matrixLocationArray[i2].column != this.cellColumn) continue;
                this.cellColumn = -1;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
                return;
            }
        }
    }

    public void remove(int n2, int n3) {
        if (this.cellColumn != -1 && n3 == this.cellColumn) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation matrixLocation) {
        if (this.cellColumn != -1 && matrixLocation.column == this.cellColumn) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(int n2, int n3, int n4, int n5) {
        if (this.cellColumn != n5) {
            this.cellColumn = n5;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        if (matrixLocation2.column != this.cellColumn) {
            this.cellColumn = matrixLocation2.column;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] matrixLocationArray) {
        if (matrixLocationArray.length > 0 && matrixLocationArray[0].column != this.cellColumn) {
            this.cellColumn = matrixLocationArray[0].column;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(int n2, int n3) {
        if (n3 != this.cellColumn) {
            this.cellColumn = n3;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation matrixLocation) {
        if (matrixLocation.column != this.cellColumn) {
            this.cellColumn = matrixLocation.column;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void set(MatrixLocation[] matrixLocationArray) {
        this.add(matrixLocationArray);
    }

    public void removeSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.remove(matrixSelectionListener);
    }

    public void addSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.add(matrixSelectionListener);
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] matrixLocationArray = new MatrixLocation[this.cellColumn != -1 ? this.rows : 0];
        if (this.cellColumn != -1) {
            for (int i2 = 0; i2 < this.rows; ++i2) {
                matrixLocationArray[i2] = new MatrixLocation(i2, this.cellColumn);
            }
        }
        return matrixLocationArray;
    }

    public int getCount() {
        return this.cellColumn != -1 ? this.rows : 0;
    }

    public boolean contains(int n2, int n3) {
        return this.cellColumn != -1 ? n3 == this.cellColumn : false;
    }

    public boolean contains(MatrixLocation matrixLocation) {
        return this.cellColumn != -1 ? matrixLocation.column == this.cellColumn : false;
    }

    public void setMaxRows(int n2) {
        this.rows = n2;
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public int getMaxRows() {
        return this.rows;
    }

    public ColumnMatrixSelection(int n2, int n3) {
        this.rows = n2;
        this.cellColumn = n3;
    }

    public ColumnMatrixSelection(int n2) {
        this.rows = n2;
    }

    public ColumnMatrixSelection() {
    }
}

