/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;

public class CrossMatrixSelection
implements Serializable,
WritableMatrixSelection {
    private boolean events = true;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private boolean valid;
    private int columns;
    private int rows;
    private MatrixLocation cell;

    protected void processSelectionEvent(MatrixSelectionEvent matrixSelectionEvent) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch(matrixSelectionEvent);
        }
    }

    public void enableSelectionEvents(boolean bl2) {
        this.events = bl2;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.valid) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void removeRange(int n2, int n3, int n4, int n5) {
        if (this.valid && (this.cell.row >= n2 && this.cell.row <= n4 || this.cell.column >= n3 && this.cell.column <= n5)) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        this.removeRange(matrixLocation.row, matrixLocation.column, matrixLocation2.row, matrixLocation2.column);
    }

    public void remove(MatrixLocation[] matrixLocationArray) {
        if (this.valid && matrixLocationArray.length > 0) {
            for (int i2 = 0; i2 < matrixLocationArray.length; ++i2) {
                if (matrixLocationArray[i2] == null || !matrixLocationArray[i2].equals(this.cell)) continue;
                this.cell = null;
                this.valid = false;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
                return;
            }
        }
    }

    public void remove(int n2, int n3) {
        if (this.valid && n2 == this.cell.row && n3 == this.cell.column) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation matrixLocation) {
        if (this.valid && matrixLocation != null && matrixLocation.equals(this.cell)) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(int n2, int n3, int n4, int n5) {
        if (n4 != this.cell.row || n5 != this.cell.column) {
            this.cell = new MatrixLocation(n4, n5);
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        if (matrixLocation2 != null && !matrixLocation2.equals(this.cell)) {
            this.cell = matrixLocation2;
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] matrixLocationArray) {
        if (matrixLocationArray.length > 0 && !matrixLocationArray[0].equals(this.cell)) {
            this.cell = matrixLocationArray[0];
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(int n2, int n3) {
        if (n2 != this.cell.row || n3 != this.cell.column) {
            this.cell = new MatrixLocation(n2, n3);
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation matrixLocation) {
        if (matrixLocation != null && !matrixLocation.equals(this.cell)) {
            this.cell = matrixLocation;
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void set(MatrixLocation[] matrixLocationArray) {
        this.add(matrixLocationArray);
    }

    public void removeSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.remove(matrixSelectionListener);
    }

    public void addSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.add(matrixSelectionListener);
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] matrixLocationArray = new MatrixLocation[this.valid ? this.rows + this.columns - 1 : 0];
        if (this.valid) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.rows; ++n2) {
                matrixLocationArray[n3++] = new MatrixLocation(n2, this.cell.column);
            }
            for (n2 = 0; n2 < this.columns; ++n2) {
                if (n2 == this.cell.column) continue;
                matrixLocationArray[n3++] = new MatrixLocation(this.cell.row, n2);
            }
        }
        return matrixLocationArray;
    }

    public int getCount() {
        return this.valid ? this.rows + this.columns - 1 : 0;
    }

    public boolean contains(int n2, int n3) {
        return this.valid ? n2 == this.cell.row || n3 == this.cell.column : false;
    }

    public boolean contains(MatrixLocation matrixLocation) {
        return this.valid ? matrixLocation.row == this.cell.row || matrixLocation.column == this.cell.column : false;
    }

    private void checkValid() {
        this.valid = this.rows > 0 && this.columns > 0 && this.cell != null;
    }

    public void setMaxColumns(int n2) {
        this.columns = n2;
        this.checkValid();
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public int getMaxColumns() {
        return this.columns;
    }

    public void setMaxRows(int n2) {
        this.rows = n2;
        this.checkValid();
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public int getMaxRows() {
        return this.rows;
    }

    public CrossMatrixSelection(int n2, int n3, MatrixLocation matrixLocation) {
        this(n2, n3);
        this.cell = matrixLocation;
        this.checkValid();
    }

    public CrossMatrixSelection(int n2, int n3) {
        this.rows = n2;
        this.columns = n3;
    }

    public CrossMatrixSelection() {
    }
}

