/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;

public class RowMatrixSelection
implements Serializable,
WritableMatrixSelection {
    private boolean events = true;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private int columns;
    private int cellRow = -1;

    protected void processSelectionEvent(MatrixSelectionEvent matrixSelectionEvent) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch(matrixSelectionEvent);
        }
    }

    public void enableSelectionEvents(boolean bl2) {
        this.events = bl2;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.cellRow != -1) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void removeRange(int n2, int n3, int n4, int n5) {
        if (this.cellRow != -1 && this.cellRow >= n2 && this.cellRow <= n4) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        this.removeRange(matrixLocation.row, matrixLocation.column, matrixLocation2.row, matrixLocation2.column);
    }

    public void remove(MatrixLocation[] matrixLocationArray) {
        if (this.cellRow != -1) {
            for (int i2 = 0; i2 < matrixLocationArray.length; ++i2) {
                if (matrixLocationArray[i2].row != this.cellRow) continue;
                this.cellRow = -1;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
                return;
            }
        }
    }

    public void remove(int n2, int n3) {
        if (this.cellRow != -1 && n2 == this.cellRow) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation matrixLocation) {
        if (this.cellRow != -1 && matrixLocation.row == this.cellRow) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(int n2, int n3, int n4, int n5) {
        if (this.cellRow != n4) {
            this.cellRow = n4;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        if (matrixLocation2.row != this.cellRow) {
            this.cellRow = matrixLocation2.row;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] matrixLocationArray) {
        if (matrixLocationArray.length > 0 && matrixLocationArray[0].row != this.cellRow) {
            this.cellRow = matrixLocationArray[0].row;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(int n2, int n3) {
        if (n2 != this.cellRow) {
            this.cellRow = n2;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation matrixLocation) {
        if (matrixLocation.row != this.cellRow) {
            this.cellRow = matrixLocation.row;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void set(MatrixLocation[] matrixLocationArray) {
        this.add(matrixLocationArray);
    }

    public void removeSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.remove(matrixSelectionListener);
    }

    public void addSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.add(matrixSelectionListener);
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] matrixLocationArray = new MatrixLocation[this.cellRow != -1 ? this.columns : 0];
        if (this.cellRow != -1) {
            for (int i2 = 0; i2 < matrixLocationArray.length; ++i2) {
                matrixLocationArray[i2] = new MatrixLocation(this.cellRow, i2);
            }
        }
        return matrixLocationArray;
    }

    public int getCount() {
        return this.cellRow != -1 ? this.columns : 0;
    }

    public boolean contains(int n2, int n3) {
        return this.cellRow != -1 ? n2 == this.cellRow : false;
    }

    public boolean contains(MatrixLocation matrixLocation) {
        return this.cellRow != -1 ? matrixLocation.row == this.cellRow : false;
    }

    public void setMaxColumns(int n2) {
        this.columns = n2;
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public int getMaxColumns() {
        return this.columns;
    }

    public RowMatrixSelection(int n2, int n3) {
        this.columns = n2;
        this.cellRow = n3;
    }

    public RowMatrixSelection(int n2) {
        this.columns = n2;
    }

    public RowMatrixSelection() {
    }
}

