/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import java.awt.Color;
import java.io.Serializable;

public class ColorWheel
implements Serializable {
    private Color current = Color.red;
    private int cycle = 1;
    private int increment = 50;
    public static final int MAGENTA_TO_RED = 6;
    public static final int BLUE_TO_MAGENTA = 5;
    public static final int CYAN_TO_BLUE = 4;
    public static final int GREEN_TO_CYAN = 3;
    public static final int YELLOW_TO_GREEN = 2;
    public static final int RED_TO_YELLOW = 1;

    public Color next(Color color) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        switch (this.cycle) {
            case 1: {
                if ((n3 += this.increment) <= 255) break;
                n3 = 255;
                this.cycle = 2;
                break;
            }
            case 2: {
                if ((n2 -= this.increment) >= 0) break;
                n2 = 0;
                this.cycle = 3;
                break;
            }
            case 3: {
                if ((n4 += this.increment) <= 255) break;
                n4 = 255;
                this.cycle = 4;
                break;
            }
            case 4: {
                if ((n3 -= this.increment) >= 0) break;
                n3 = 0;
                this.cycle = 5;
                break;
            }
            case 5: {
                if ((n2 += this.increment) <= 255) break;
                n2 = 255;
                this.cycle = 6;
                break;
            }
            case 6: {
                if ((n4 -= this.increment) >= 0) break;
                n4 = 0;
                this.cycle = 1;
                break;
            }
            default: {
                this.cycle = 1;
            }
        }
        this.current = new Color(n2, n3, n4);
        return this.current;
    }

    public Color next() {
        return this.next(this.current);
    }

    public void setColor(Color color) {
        if (color != null) {
            this.current = color;
        }
    }

    public Color getColor() {
        return this.current;
    }

    public void setCycle(int n2) {
        if (n2 < 1 || n2 > 6) {
            throw new IllegalArgumentException(String.valueOf("Invalid ColorWheel cycle: ").concat(String.valueOf(n2)));
        }
        this.cycle = n2;
    }

    public int getCycle() {
        return this.cycle;
    }

    public void setIncrement(int n2) {
        if (n2 < 1 || n2 > 255) {
            throw new IllegalArgumentException("ColorWheel increment must be in range (1-255)");
        }
        this.increment = n2;
    }

    public int getIncrement() {
        return this.increment;
    }

    public ColorWheel(Color color, int n2, int n3) {
        this.current = color;
        this.cycle = n2;
        this.increment = n3;
    }

    public ColorWheel(Color color, int n2) {
        this.current = color;
        this.cycle = n2;
    }

    public ColorWheel(Color color) {
        this.current = color;
    }

    public ColorWheel() {
    }
}

