/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.util.ActionMulticaster;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.util.SerializableImage;
import com.borland.jbcl.view.BeanPanel$1;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;

public class BeanPanel
extends JComponent
implements Serializable {
    transient Rectangle _bounds;
    protected transient boolean foundParentWindow = false;
    protected int focusState;
    protected boolean focusAware = true;
    protected transient Image texture;
    protected transient ActionMulticaster actionMulticaster;
    protected transient WindowListener winListener = new BeanPanel$1(this);
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof SerializableImage) {
            this.texture = ((SerializableImage)object).getImage();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.texture != null) {
            objectOutputStream.writeObject(SerializableImage.create(this.texture));
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    protected void dropParentWindow() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (container instanceof Window) {
            ((Window)container).removeWindowListener(this.winListener);
        }
        this.foundParentWindow = false;
    }

    protected void findParentWindow() {
        Container container;
        if (this.foundParentWindow) {
            return;
        }
        for (container = this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (container instanceof Window) {
            ((Window)container).addWindowListener(this.winListener);
            this.foundParentWindow = true;
        }
    }

    public void removeNotify() {
        this.dropParentWindow();
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        this.findParentWindow();
    }

    public void windowActiveChanged(boolean bl2) {
        this.focusState = bl2 ? (this.focusState &= 0xFFFFFFDF) : (this.focusState |= 0x20);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusAware) {
            switch (focusEvent.getID()) {
                case 1004: {
                    this.focusState |= 2;
                    break;
                }
                case 1005: {
                    this.focusState &= 0xFFFFFFFD;
                }
            }
        }
        super.processFocusEvent(focusEvent);
    }

    public boolean isFocusTraversable() {
        return this.focusAware;
    }

    protected boolean isFocusAware() {
        return this.focusAware;
    }

    protected void setFocusAware(boolean bl2) {
        this.focusAware = bl2;
    }

    protected void processMouseDragged(MouseEvent mouseEvent) {
    }

    protected void processMouseMoved(MouseEvent mouseEvent) {
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
    }

    protected void processMouseEntered(MouseEvent mouseEvent) {
    }

    protected void processMouseClicked(MouseEvent mouseEvent) {
    }

    protected void processMouseReleased(MouseEvent mouseEvent) {
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1 && this.isFocusTraversable()) {
            this.requestFocus();
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseMotionEvent(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            switch (mouseEvent.getID()) {
                case 503: {
                    this.processMouseMoved(mouseEvent);
                    break;
                }
                case 506: {
                    this.processMouseDragged(mouseEvent);
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.processMousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.processMouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    this.processMouseClicked(mouseEvent);
                    break;
                }
                case 504: {
                    this.processMouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this.processMouseExited(mouseEvent);
                }
            }
        }
    }

    protected void processKeyReleased(KeyEvent keyEvent) {
    }

    protected void processKeyTyped(KeyEvent keyEvent) {
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            switch (keyEvent.getID()) {
                case 401: {
                    this.processKeyPressed(keyEvent);
                    break;
                }
                case 400: {
                    this.processKeyTyped(keyEvent);
                    break;
                }
                case 402: {
                    this.processKeyReleased(keyEvent);
                }
            }
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.dispatch(actionEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isOpaque()) {
            Rectangle rectangle = graphics.getClipBounds();
            if (this.texture != null) {
                ImageTexture.texture(this.texture, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    public boolean isOpaque() {
        return this.texture != null ? true : super.isOpaque();
    }

    public void setOpaque(boolean bl2) {
        super.setOpaque(bl2);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public Image getTexture() {
        return this.texture;
    }

    public void setTexture(Image image) {
        this.texture = image;
        if (image != null) {
            ImageLoader.waitForImage(this, image);
        }
        this.repaint();
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.remove(actionListener);
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionMulticaster == null) {
            this.actionMulticaster = new ActionMulticaster();
        }
        this.actionMulticaster.add(actionListener);
    }

    public BeanPanel(LayoutManager layoutManager) {
        this._bounds = new Rectangle();
        this.enableEvents(60L);
        super.setLayout(layoutManager);
        super.setDoubleBuffered(true);
        super.setOpaque(true);
    }

    public BeanPanel() {
        this._bounds = new Rectangle();
        this.enableEvents(60L);
        super.setLayout(new FlowLayout());
        super.setDoubleBuffered(true);
        super.setOpaque(true);
    }
}

