/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.SingletonViewManager;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.SingletonView;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ButtonView
extends BeanPanel
implements Serializable,
ItemPaintSite,
SingletonModelListener,
SingletonView {
    protected Border dnBorder;
    protected Border upBorder;
    protected boolean mouseOver;
    protected boolean mouseDown;
    protected int alignment = 34;
    protected int state;
    protected String actionCommand;
    protected Insets margins;
    private boolean showRollover = false;
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    private boolean readOnly;
    private transient SingletonViewManager viewManager;
    private transient WritableSingletonModel writeModel;
    private transient SingletonModel model;
    boolean dragging = false;
    boolean dragOut = false;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v2 = hashtable.get("m");
        if (v2 instanceof SingletonModel) {
            this.model = (SingletonModel)v2;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
        if ((v2 = hashtable.get("v")) instanceof SingletonViewManager) {
            this.viewManager = (SingletonViewManager)v2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        if (this.model instanceof Serializable) {
            hashtable.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hashtable.put("v", this.viewManager);
        }
        objectOutputStream.writeObject(hashtable);
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",label="))).concat(String.valueOf(this.getLabel()))).concat(String.valueOf(",state="))).concat(String.valueOf(this.state));
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
        super.processMouseExited(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            if (this.dragging) {
                return;
            }
            this.mouseOver = false;
            boolean bl2 = false;
            if (this.mouseDown) {
                this.state &= 0xFFFFFFFB;
                bl2 = true;
            }
            if (this.showRollover && !this.mouseDown) {
                this.state &= 0xFFFFFFBF;
                bl2 = true;
            }
            if (bl2) {
                this.repaint();
            }
        }
    }

    protected void processMouseEntered(MouseEvent mouseEvent) {
        super.processMouseEntered(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            if (this.dragging) {
                return;
            }
            this.mouseOver = true;
            boolean bl2 = false;
            if (this.mouseDown) {
                this.state |= 4;
                bl2 = true;
            }
            if (this.showRollover) {
                this.state |= 0x40;
                bl2 = true;
            }
            if (bl2) {
                this.repaint();
            }
        }
    }

    protected void processMouseDragged(MouseEvent mouseEvent) {
        super.processMouseDragged(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            this.state &= 0xFFFFFFBF;
            this.dragging = true;
            if (!this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                if (!this.dragOut) {
                    this.dragOut = true;
                    this.mouseOver = false;
                    if (this.mouseDown) {
                        this.state &= 0xFFFFFFFB;
                        this.repaint();
                    }
                }
            } else if (this.dragOut) {
                this.dragOut = false;
                this.mouseOver = true;
                if (this.mouseDown) {
                    this.state |= 4;
                    this.repaint();
                }
            }
        }
    }

    protected void processMouseReleased(MouseEvent mouseEvent) {
        super.processMouseReleased(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            this.dragging = false;
            boolean bl2 = (this.state & 4) != 0;
            this.state &= 0xFFFFFFFB;
            this.mouseDown = false;
            if (this.mouseOver && this.showRollover) {
                this.state |= 0x40;
            }
            this.repaint();
            if (bl2) {
                this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
            }
        }
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        super.processMousePressed(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            this.state |= 4;
            this.state &= 0xFFFFFFBF;
            this.mouseDown = true;
            this.mouseOver = true;
            this.repaint();
        }
    }

    protected void processKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.state &= 0xFFFFFFFB;
            this.repaint();
            this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 32: {
                this.state |= 4;
                this.repaint();
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005) {
            this.state &= 0xFFFFFFFB;
        }
        if (this.focusAware) {
            this.repaint(100L);
        }
    }

    public void setVisible(boolean bl2) {
        if (!bl2) {
            this.mouseDown = false;
            this.setSelected(false);
        }
        super.setVisible(bl2);
    }

    public void paintComponent(Graphics graphics) {
        ItemPainter itemPainter;
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        Insets insets = new Insets(0, 0, 0, 0);
        if ((this.state & 4) != 0) {
            insets = this.dnBorder.getBorderInsets(this);
        } else if (!this.showRollover || (this.state & 0x40) != 0) {
            insets = this.upBorder.getBorderInsets(this);
        }
        Dimension dimension2 = new Dimension(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        Object object = this.model != null ? this.model.get() : null;
        ItemPainter itemPainter2 = itemPainter = this.viewManager != null ? this.viewManager.getPainter(object, this.state | this.focusState) : null;
        if (itemPainter != null) {
            Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension2.width, dimension2.height);
            Rectangle rectangle2 = graphics.getClipBounds();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor((this.state & 4) != 0 ? UIManager.getColor("Button.pressed") : this.getBackground());
            graphics.setFont(this.getFont());
            itemPainter.paint(object, graphics, rectangle, this.state | this.focusState, this);
            graphics.setClip(rectangle2);
        }
    }

    public void paintBorder(Graphics graphics) {
        if ((this.state & 4) != 0) {
            this.dnBorder.paintBorder(this, graphics, 0, 0, this.getSize().width, this.getSize().height);
        } else if (!this.showRollover || (this.state & 0x40) != 0) {
            this.upBorder.paintBorder(this, graphics, 0, 0, this.getSize().width, this.getSize().height);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        this.repaint(300L);
    }

    public Dimension getPreferredSize() {
        Object object;
        Graphics graphics = this.getGraphics();
        Border border = (this.state & 4) != 0 ? this.dnBorder : this.upBorder;
        Insets insets = border.getBorderInsets(this);
        if (this.model != null && this.viewManager != null && (object = this.model.get()) != null) {
            Dimension dimension = this.viewManager.getPainter(object, this.state | this.focusState).getPreferredSize(object, graphics, this.state | this.focusState, this);
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right + 20, insets.top + insets.bottom + 10);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        this.repaint(100L);
    }

    public void setViewManager(SingletonViewManager singletonViewManager) {
        this.viewManager = singletonViewManager;
    }

    public SingletonViewManager getViewManager() {
        return this.viewManager;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean bl2) {
        this.readOnly = bl2;
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)this.model : null;
        this.repaint(100L);
    }

    public void setEnabled(boolean bl2) {
        if (this.isEnabled() != bl2) {
            if (bl2) {
                this.state &= 0xFFFFFFFE;
            } else {
                this.state |= 1;
                this.state &= 0xFFFFFFBF;
                this.state &= 0xFFFFFFFB;
            }
            super.setEnabled(bl2);
            this.repaint(100L);
        }
    }

    public void setSelected(boolean bl2) {
        this.state = bl2 ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.repaint(100L);
    }

    public boolean isSelected() {
        return (this.state & 4) != 0;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setShowRollover(boolean bl2) {
        this.showRollover = bl2;
        this.repaint(100L);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public boolean isFocusAware() {
        return super.isFocusAware();
    }

    public void setFocusAware(boolean bl2) {
        super.setFocusAware(bl2);
        this.repaint(100L);
    }

    public void setLabel(String string) {
        if (!this.isReadOnly()) {
            this.writeModel.set(string);
            this.repaint(100L);
        }
    }

    public String getLabel() {
        Object object = this.model != null ? this.model.get() : null;
        return object != null ? object.toString() : "";
    }

    public Component getSiteComponent() {
        return this;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public void setItemMargins(Insets insets) {
        this.margins = insets;
    }

    protected SingletonViewManager createDefaultViewManager() {
        return new BasicViewManager(new FocusableItemPainter(new TextItemPainter()));
    }

    protected SingletonModel createDefaultModel() {
        return new BasicSingletonContainer();
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("Button.background"));
        super.setForeground(UIManager.getColor("Button.foreground"));
        this.upBorder = BorderFactory.createRaisedBevelBorder();
        this.dnBorder = BorderFactory.createLoweredBevelBorder();
    }

    public ButtonView() {
        super(null);
        this.margins = new Insets(2, 5, 2, 5);
        this.upBorder = BorderFactory.createRaisedBevelBorder();
        this.dnBorder = BorderFactory.createLoweredBevelBorder();
        super.setBackground(UIManager.getColor("Button.background"));
        super.setForeground(UIManager.getColor("Button.foreground"));
        this.upBorder = BorderFactory.createRaisedBevelBorder();
        this.dnBorder = BorderFactory.createLoweredBevelBorder();
        this.setModel(this.createDefaultModel());
        this.setViewManager(this.createDefaultViewManager());
    }
}

