/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.util.DottedLine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FocusableItemPainter
implements Serializable,
ItemPainter {
    protected Color rollColor = SystemColor.textHighlight;
    protected boolean showRollover = true;
    protected transient ItemPainter painter;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof ItemPainter) {
            this.painter = (ItemPainter)object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.painter instanceof Serializable ? this.painter : null);
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n2, ItemPaintSite itemPaintSite) {
        Color color = graphics.getColor();
        if (this.painter != null) {
            this.painter.paint(object, graphics, rectangle, n2, itemPaintSite);
        }
        if ((n2 & 2) != 0) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            DottedLine.drawRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setPaintMode();
        } else if (this.showRollover && (n2 & 0x40) != 0) {
            graphics.setColor(this.rollColor);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.setColor(color);
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n2, ItemPaintSite itemPaintSite) {
        return this.painter != null ? this.painter.getPreferredSize(object, graphics, n2, itemPaintSite) : new Dimension(0, 0);
    }

    public Color getRollColor() {
        return this.rollColor;
    }

    public void setRolloverColor(Color color) {
        this.rollColor = color;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setShowRollover(boolean bl2) {
        this.showRollover = bl2;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setPainter(ItemPainter itemPainter) {
        this.painter = itemPainter;
    }

    public FocusableItemPainter(ItemPainter itemPainter, boolean bl2) {
        this.painter = itemPainter;
        this.showRollover = bl2;
    }

    public FocusableItemPainter(ItemPainter itemPainter) {
        this.painter = itemPainter;
    }

    public FocusableItemPainter() {
        this.painter = null;
    }
}

