/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.Res;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.Serializable;

public class ImageItemPainter
implements Serializable,
ItemPainter {
    protected boolean genDisabledImage = true;
    protected boolean paintBackground = true;
    protected boolean streamResetError;
    protected int alignment;
    protected Component component;

    protected Image getImage(Object object, int n2) {
        Image image;
        if (object == null) {
            return null;
        }
        this.streamResetError = false;
        if (object instanceof Image) {
            image = (Image)object;
        } else {
            try {
                image = ImageLoader.loadFromBlob(object, this.component, true);
            }
            catch (IOException iOException) {
                this.streamResetError = true;
                image = null;
            }
        }
        if (image == null) {
            return null;
        }
        if (this.genDisabledImage && (n2 & 1) != 0) {
            return ImageLoader.getDisabledImage(this.component, image);
        }
        return image;
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n2, ItemPaintSite itemPaintSite) {
        boolean bl2;
        Color color;
        if (itemPaintSite != null && itemPaintSite.getSiteComponent() != null) {
            this.component = itemPaintSite.getSiteComponent();
        }
        Image image = this.getImage(object, n2);
        Color color2 = graphics.getColor();
        Color color3 = color = itemPaintSite != null ? itemPaintSite.getBackground() : graphics.getColor();
        if (color == null) {
            color = graphics.getColor();
        }
        graphics.setColor(color);
        boolean bl3 = itemPaintSite != null ? itemPaintSite.isTransparent() : (bl2 = !this.paintBackground);
        if (!bl2) {
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.streamResetError) {
            graphics.setColor(SystemColor.windowText);
            graphics.drawString(Res.getString(9), rectangle.x, rectangle.y);
        } else if (image != null) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = image.getWidth(this.component);
            int n9 = image.getHeight(this.component);
            int n10 = n7 = itemPaintSite != null ? itemPaintSite.getAlignment() : this.alignment;
            if (n7 == 0) {
                n7 = this.alignment;
            }
            switch (n7 & 0xF) {
                default: {
                    n6 = rectangle.x;
                    n5 = n8;
                    break;
                }
                case 2: {
                    n6 = rectangle.x + (rectangle.width - n8) / 2;
                    n5 = n8;
                    break;
                }
                case 3: {
                    n6 = rectangle.x + rectangle.width - n8;
                    n5 = n8;
                    break;
                }
                case 4: {
                    n6 = rectangle.x;
                    n5 = rectangle.width;
                }
            }
            switch (n7 & 0xF0) {
                default: {
                    n4 = rectangle.y;
                    n3 = n9;
                    break;
                }
                case 32: {
                    n4 = rectangle.y + (rectangle.height - n9) / 2;
                    n3 = n9;
                    break;
                }
                case 48: {
                    n4 = rectangle.y + rectangle.height - n9;
                    n3 = n9;
                    break;
                }
                case 64: {
                    n4 = rectangle.y;
                    n3 = rectangle.height;
                }
            }
            graphics.drawImage(image, n6, n4, n5, n3, this.component);
        }
        graphics.setColor(color2);
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n2, ItemPaintSite itemPaintSite) {
        Image image;
        if (itemPaintSite != null && itemPaintSite.getSiteComponent() != null) {
            this.component = itemPaintSite.getSiteComponent();
        }
        return (image = this.getImage(object, n2)) == null ? new Dimension() : new Dimension(image.getWidth(this.component), image.getHeight(this.component));
    }

    public boolean isGenDisabledImage() {
        return this.genDisabledImage;
    }

    public void setGenDisabledImage(boolean bl2) {
        this.genDisabledImage = bl2;
    }

    public boolean isPaintBackground() {
        return this.paintBackground;
    }

    public void setPaintBackground(boolean bl2) {
        this.paintBackground = bl2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        if ((n2 & 0xF0) < 0 || (n2 & 0xF0) > 64) {
            throw new IllegalArgumentException(Res.format(1, new Integer[]{new Integer(n2 & 0xF0)}));
        }
        if ((n2 & 0xF) < 0 || (n2 & 0xF) > 4) {
            throw new IllegalArgumentException(Res.format(2, new Integer[]{new Integer(n2 & 0xF)}));
        }
        this.alignment = n2;
    }

    public ImageItemPainter(Component component, int n2, boolean bl2) {
        this.component = component;
        this.alignment = n2;
        this.paintBackground = bl2;
    }

    public ImageItemPainter(Component component, int n2) {
        this.component = component;
        this.alignment = n2;
    }

    public ImageItemPainter(Component component) {
        this(component, 68);
    }

    public ImageItemPainter() {
    }
}

