/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.objectspace.jgl.Array;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.Enumeration;

public class TextWrapper
implements Serializable {
    Dimension size;
    int maxAscent;
    int charHeight;
    int lineCount;
    int hintWidth;
    String text;
    int[] length;
    String[] lines;
    Font font;
    BreakIterator textBoundary;
    FontMetrics fontMetrics;
    int alignment;
    private static final long serialVersionUID = 200L;

    public void paint(Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = n3 + n5 + this.charHeight;
        int n7 = this.alignment & 0xF;
        int n8 = this.alignment & 0xF0;
        n3 -= this.charHeight - this.maxAscent;
        switch (n8) {
            case 32: {
                n3 += (n5 - this.lineCount * this.charHeight) / 2;
                break;
            }
            case 48: {
                n3 += n5 - this.lineCount * this.charHeight;
            }
        }
        for (int i2 = 0; i2 < this.lineCount; ++i2) {
            int n9 = 0;
            switch (n7) {
                case 2: {
                    n9 = (n4 - this.length[i2]) / 2;
                    break;
                }
                case 3: {
                    n9 = n4 - this.length[i2];
                }
            }
            if (this.lines[i2] != null) {
                graphics.drawString(this.lines[i2], n2 + n9, n3 + this.charHeight);
            }
            if ((n3 += this.charHeight) <= n6) continue;
            return;
        }
    }

    protected void calcSize(Graphics graphics) {
        Array array = new Array();
        this.textBoundary.setText(this.text);
        int n2 = this.textBoundary.first();
        int n3 = this.textBoundary.next();
        while (n3 != -1) {
            array.add(this.text.substring(n2, n3));
            n2 = n3;
            n3 = this.textBoundary.next();
        }
        this.lines = new String[array.size()];
        this.length = new int[array.size()];
        this.lineCount = 0;
        n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Enumeration enumeration = array.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl2;
            String string = (String)enumeration.nextElement();
            int n7 = this.fontMetrics.stringWidth(string);
            int n8 = this.length[n4] + n7;
            boolean bl3 = string.charAt(0) == '\r';
            boolean bl4 = bl2 = string.charAt(0) == '\n';
            if (bl3) continue;
            if (!bl2 && n8 <= this.hintWidth) {
                if (this.lines[n4] == null) {
                    this.lines[n4] = string;
                    this.length[n4] = n7;
                    n3 = 0;
                    ++this.lineCount;
                    n6 += this.charHeight;
                    if (n8 <= n5) continue;
                    n5 = n8;
                    continue;
                }
                this.lines[n4] = String.valueOf(this.lines[n4]).concat(String.valueOf(string));
                this.length[n4] = n8;
                if (n8 <= n5) continue;
                n5 = n8;
                continue;
            }
            if (bl2) {
                n7 = 0;
                string = string.substring(1);
            }
            if (n7 > n5) {
                n5 = n7;
            }
            if (this.length[n4] == 0) {
                this.lines[n4] = string;
                this.length[n4] = n7;
                ++this.lineCount;
                ++n4;
            } else {
                ++this.lineCount;
                this.lines[++n4] = string;
                this.length[n4] = n7;
            }
            n3 = 0;
            n6 += this.charHeight;
        }
        this.size = new Dimension(n5, n6);
    }

    public Dimension getSize(Graphics graphics) {
        if (this.size == null) {
            this.calcSize(graphics);
        }
        return this.size;
    }

    TextWrapper(Font font, String string, int n2, int n3) {
        this.alignment = n2;
        this.font = font;
        this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.textBoundary = BreakIterator.getWordInstance();
        this.text = string;
        this.hintWidth = n3;
        this.charHeight = this.fontMetrics.getHeight();
        this.maxAscent = this.fontMetrics.getMaxAscent();
    }
}

