/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.VectorIterator;
import java.util.Enumeration;
import java.util.Vector;

public class VectorArray
extends ArrayAdapter {
    Vector array;
    static final long serialVersionUID = -7811353276265744416L;

    public VectorArray() {
        this(new Vector());
    }

    public VectorArray(Vector vector) {
        Vector vector2 = vector;
        synchronized (vector2) {
            this.array = vector;
            return;
        }
    }

    public VectorArray(VectorArray vectorArray) {
        this(vectorArray.array);
    }

    public synchronized Object clone() {
        return new VectorArray(this);
    }

    public synchronized String toString() {
        return this.array.toString();
    }

    public boolean equals(Object object) {
        return object instanceof VectorArray && ((Object)this.array).equals(((VectorArray)object).array) || object instanceof Vector && ((Object)this.array).equals(object);
    }

    public Vector get() {
        return this.array;
    }

    public int size() {
        return this.array.size();
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized VectorIterator begin() {
        return new VectorIterator(this, 0);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized VectorIterator end() {
        return new VectorIterator(this, this.array.size());
    }

    public synchronized Object at(int n2) {
        return this.array.elementAt(n2);
    }

    public synchronized void put(int n2, Object object) {
        this.array.setElementAt(object, n2);
    }

    public void clear() {
        this.array.removeAllElements();
    }

    public synchronized Object add(Object object) {
        this.array.addElement(object);
        return null;
    }

    public synchronized void pushFront(Object object) {
        this.array.insertElementAt(object, 0);
    }

    public synchronized Object popFront() {
        Object e2 = this.array.firstElement();
        this.array.removeElementAt(0);
        return e2;
    }

    public void pushBack(Object object) {
        this.add(object);
    }

    public synchronized Object popBack() {
        Object e2 = this.array.lastElement();
        this.array.removeElementAt(this.array.size() - 1);
        return e2;
    }

    public synchronized int remove(Object object) {
        int n2 = 0;
        while (this.array.removeElement(object)) {
            ++n2;
        }
        return n2;
    }

    public synchronized int remove(Object object, int n2) {
        int n3 = 0;
        while (n2 > 0 && this.array.removeElement(object)) {
            ++n3;
            --n2;
        }
        return n3;
    }

    public synchronized int remove(int n2, int n3, Object object) {
        if (n2 < 0 || n3 > this.array.size() - 1) {
            throw new IndexOutOfBoundsException("index out of range for this Vector.");
        }
        int n4 = 0;
        int n5 = n2;
        int n6 = n2;
        while (n6 < n3) {
            if (this.array.elementAt(n5).equals(object)) {
                this.array.removeElementAt(n5);
                ++n4;
            } else {
                ++n5;
            }
            ++n6;
        }
        return n4;
    }
}

