/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Browser;
import ice.htmlbrowser.Document;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;

public class ICEBrowser
extends Applet
implements Externalizable,
WindowListener,
ActionListener,
PropertyChangeListener {
    private Browser bb;
    private Frame \u01a3;
    private TextField \u01a4;
    private TextField \u01a5;
    private Label \u00de;
    private Panel \u01a6;
    private boolean \u01a7 = true;
    private boolean \u01a8 = true;
    private String \u01a9;
    private Properties \u01aa = new Properties();

    public static void main(String[] stringArray) {
        String string = new String("http://www.icesoft.no");
        Frame frame = new Frame();
        ICEBrowser iCEBrowser = new ICEBrowser(stringArray.length >= 1 ? stringArray[0] : string, frame);
        frame.add(iCEBrowser);
        ((Component)frame).setSize(400, 600);
        ((Component)frame).setVisible(true);
    }

    public ICEBrowser() {
        this(null, null);
    }

    public ICEBrowser(String string, Frame frame) {
        Serializable serializable;
        this.\u01a9 = string;
        this.\u01a3 = frame;
        this.setLayout(new BorderLayout());
        if (frame != null) {
            frame.addWindowListener(this);
        }
        if (frame != null && (serializable = File.separatorChar == '/' ? this.getClass().getResource("ibicon48.gif") : this.getClass().getResource("ibicon32.gif")) != null) {
            frame.setIconImage(this.getToolkit().getImage((URL)serializable));
        }
        serializable = new Panel();
        ((Container)serializable).setLayout(new FlowLayout(0));
        ((Component)serializable).setFont(new Font("SansSerif", 1, 14));
        Button button = new Button("Back");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        button = new Button("Forward");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        button = new Button("Reload");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        button = new Button("Stop");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        button = new Button("Scroll");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        button = new Button("Print");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        this.\u01a5 = new TextField("encoding", 15);
        this.\u01a5.setFont(new Font("SansSerif", 0, 12));
        this.\u01a5.addActionListener(this);
        ((Container)serializable).add(this.\u01a5);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        this.\u01a4 = new TextField(80);
        this.\u01a4.addActionListener(this);
        panel.add(this.\u01a4);
        this.\u01a6 = new Panel();
        this.\u01a6.setLayout(new BorderLayout());
        this.\u01a6.setBackground(Color.lightGray);
        this.\u01a6.add("North", (Component)serializable);
        this.\u01a6.add("South", panel);
        this.\u00de = new Label("ICE Browser " + Document.theVersion, 1);
        this.add("North", this.\u01a6);
        this.add("South", this.\u00de);
        this.bb = new Browser();
        this.bb.addPropertyChangeListener(this);
        this.add("Center", this.bb);
        this.setSize(300, 400);
        if (string != null) {
            this.bb.gotoLocation(string, "_top", null);
        }
    }

    public Browser getBrowser() {
        return this.bb;
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.\u01a4) {
            this.bb.gotoLocation(this.\u01a4.getText());
            return;
        }
        if (actionEvent.getSource() == this.\u01a5) {
            this.bb.setEncoding(this.\u01a5.getText());
            return;
        }
        if (string.equals("Scroll")) {
            this.bb.setScrollPaneMode(!this.bb.isScrollPaneMode());
            return;
        }
        if (string.equals("Back")) {
            this.bb.goBack();
            return;
        }
        if (string.equals("Forward")) {
            this.bb.goForward();
            return;
        }
        if (string.equals("Reload")) {
            this.bb.reload();
            return;
        }
        if (string.equals("Stop")) {
            this.bb.htmlInterrupt();
            return;
        }
        if (string.equals("Print")) {
            this.printDoc();
        }
    }

    private void printDoc() {
        PrintJob printJob = this.getToolkit().getPrintJob(this.\u01a3, "ICE Browser", this.\u01aa);
        if (printJob != null) {
            this.bb.printDoc(printJob);
            printJob.end();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.bb) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("statusString")) {
                this.\u00de.setText((String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("documentBase")) {
                ((TextComponent)this.\u01a4).setText((String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("documentTitle") && this.\u01a3 != null) {
                this.\u01a3.setTitle("ICE Browser - [" + propertyChangeEvent.getNewValue() + "]");
            }
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public String getVersion() {
        return Document.theVersion;
    }

    public void setVersion(String string) {
    }

    public String getCurrentLocation() {
        this.bb.setCurrentFrame("_top");
        return this.bb.getCurrentLocation();
    }

    public void setCurrentLocation(String string) {
        this.bb.gotoLocation(string);
    }

    public void setVisibleStatus(boolean bl2) {
        if (this.\u01a8 && !bl2) {
            this.\u01a8 = false;
            this.remove(this.\u00de);
            this.validate();
            return;
        }
        if (!this.\u01a8 && bl2) {
            this.\u01a8 = true;
            this.add("South", this.\u00de);
            this.validate();
        }
    }

    public boolean isVisibleStatus() {
        return this.\u01a8;
    }

    public void setVisibleControl(boolean bl2) {
        if (this.\u01a7 && !bl2) {
            this.\u01a7 = false;
            this.remove(this.\u01a6);
            this.validate();
            return;
        }
        if (!this.\u01a7 && bl2) {
            this.\u01a7 = true;
            this.add("North", this.\u01a6);
            this.validate();
        }
    }

    public boolean isVisibleControl() {
        return this.\u01a7;
    }

    public void writeExternal(ObjectOutput objectOutput) {
        try {
            objectOutput.writeObject(this.getSize());
            objectOutput.writeObject(new Boolean(this.isVisibleControl()));
            objectOutput.writeObject(this.getCurrentLocation());
            objectOutput.writeObject(this.getName());
            return;
        }
        catch (IOException iOException) {
            System.err.println("ICE Browser: cannot serialize");
            return;
        }
    }

    public void readExternal(ObjectInput objectInput) {
        try {
            Dimension dimension = (Dimension)objectInput.readObject();
            Boolean bl2 = (Boolean)objectInput.readObject();
            this.\u01a9 = (String)objectInput.readObject();
            String string = (String)objectInput.readObject();
            this.setSize(dimension);
            this.setName(string);
            this.setVisibleControl(bl2);
            this.invalidate();
            this.validate();
            return;
        }
        catch (Exception exception) {
            System.err.println("ICE Browser: cannot deserialize");
            return;
        }
    }
}

