/*
 * Decompiled with CFR 0.152.
 */
package COM.cloudscape.core;

import c8e.e.c_;
import c8e.g.d;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class WebLogicDriver
implements Driver {
    public static final String WEBLOGIC_PROTOCOL = "jdbc:cloudscape:weblogic:";
    public static final String WEBLOGIC_SSL_PROTOCOL = "jdbc:cloudscape:weblogic-ssl:";
    private static final String webLogicDriverV1 = "weblogic.jdbc.t3.Driver";
    private static final String webLogicDriverV2 = "weblogic.jdbc20.t3.Driver";
    private static String webLogicURL = null;
    private static String webLogicSSLURL = null;
    private static final String webLogicUrlV1 = "jdbc:weblogic:t3?weblogic.t3.serverURL=t3:";
    private static final String webLogicSslUrlV1 = "jdbc:weblogic:t3?weblogic.t3.serverURL=t3s:";
    private static final String webLogicUrlV2 = "jdbc20:weblogic:t3?weblogic.t3.serverURL=t3:";
    private static final String webLogicSslUrlV2 = "jdbc20:weblogic:t3?weblogic.t3.serverURL=t3s:";
    private static final String webLogicAddOn4Bugs = "&weblogic.t3.preserveSetObject=true";
    private static final String JBMSdriver = "&weblogic.t3.driverClassName=COM.cloudscape.core.JDBCDriver&weblogic.t3.driverURL=jdbc:cloudscape:";
    private static final String DOUBLE_SLASH = "//";
    private static final String LOCAL = "local:";
    private static final String DEFAULT_HOST = "//localhost:7001";
    private static final String DEFAULT_SSL_HOST = "//localhost:7002";

    public boolean acceptsURL(String string) {
        boolean bl = string.startsWith(WEBLOGIC_PROTOCOL) || string.startsWith(WEBLOGIC_SSL_PROTOCOL);
        return bl;
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        Connection connection = null;
        if (this.acceptsURL(string)) {
            connection = DriverManager.getConnection(this.translate(string), properties);
        }
        return connection;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = this.translate(string);
        return this.getWebLogicDriver(string2).getPropertyInfo(string2, properties);
    }

    public int getMajorVersion() {
        int n2 = 1;
        try {
            n2 = this.getWebLogicDriver().getMajorVersion();
        }
        catch (SQLException sQLException) {}
        return n2;
    }

    public int getMinorVersion() {
        int n2 = 0;
        try {
            n2 = this.getWebLogicDriver().getMinorVersion();
        }
        catch (SQLException sQLException) {}
        return n2;
    }

    public boolean jdbcCompliant() {
        boolean bl = false;
        try {
            bl = this.getWebLogicDriver().jdbcCompliant();
        }
        catch (SQLException sQLException) {}
        return bl;
    }

    private String translate(String string) throws SQLException {
        String string2 = null;
        if (!this.acceptsURL(string)) {
            return string;
        }
        boolean bl = string.startsWith(WEBLOGIC_SSL_PROTOCOL);
        String string3 = bl ? string.substring(WEBLOGIC_SSL_PROTOCOL.length()) : string.substring(WEBLOGIC_PROTOCOL.length());
        if (string3.startsWith(DOUBLE_SLASH)) {
            int n2 = string3.indexOf(47, 2);
            if (n2 == -1) {
                throw new SQLException(String.valueOf(string3) + d.getTextMessage("I022"));
            }
            string2 = string3.substring(0, n2);
            string3 = string3.substring(n2 + 1);
            int n3 = string2.indexOf(58);
            if (n3 == -1 || string2.lastIndexOf(58) != n3) {
                throw new SQLException(String.valueOf(string2) + d.getTextMessage("I023"));
            }
            try {
                int n4 = Integer.parseInt(string2.substring(n3 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException(String.valueOf(string2) + d.getTextMessage("I023"));
            }
        } else {
            String string4 = string2 = bl ? DEFAULT_SSL_HOST : DEFAULT_HOST;
            if (string3.startsWith(LOCAL)) {
                string3 = string3.substring(6);
            }
        }
        String string5 = bl ? String.valueOf(webLogicSSLURL) + string2 + webLogicAddOn4Bugs + JBMSdriver + string3 : String.valueOf(webLogicURL) + string2 + webLogicAddOn4Bugs + JBMSdriver + string3;
        return string5;
    }

    private Driver getWebLogicDriver(String string) throws SQLException {
        return DriverManager.getDriver(string);
    }

    private Driver getWebLogicDriver() throws SQLException {
        return this.getWebLogicDriver(webLogicURL);
    }

    static {
        try {
            Class<?> clazz = null;
            if (c_.JDK_ID == 2) {
                try {
                    clazz = Class.forName(webLogicDriverV2);
                    webLogicURL = webLogicUrlV2;
                    webLogicSSLURL = webLogicSslUrlV2;
                }
                catch (Exception exception) {}
            }
            if (clazz == null) {
                Class.forName(webLogicDriverV1);
                webLogicURL = webLogicUrlV1;
                webLogicSSLURL = webLogicSslUrlV1;
            }
            DriverManager.registerDriver(new WebLogicDriver());
        }
        catch (Throwable throwable) {
            PrintStream printStream = DriverManager.getLogStream();
            if (printStream != null) {
                printStream = System.err;
            }
            throwable.printStackTrace(printStream);
        }
    }
}

