/*
 * Decompiled with CFR 0.152.
 */
package examples.ejb20.homeMethods;

import examples.ejb20.homeMethods.ProcessingErrorException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.NoSuchEntityException;
import javax.ejb.ObjectNotFoundException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class AccountBean
implements EntityBean {
    private static final boolean VERBOSE = true;
    private EntityContext ctx;
    private String accountId;
    private double balance;

    public double balance() {
        return this.balance;
    }

    private void cleanup(Connection connection, PreparedStatement preparedStatement) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (Exception exception) {
            this.log("Error closing PreparedStatement: " + exception);
            throw new EJBException(exception);
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            this.log("Error closing Connection: " + exception);
            throw new EJBException(exception);
        }
    }

    public double deposit(double d) {
        this.log("Depositing $" + d + " into '" + this.accountId + "'");
        this.balance += d;
        return this.balance;
    }

    public void ejbActivate() {
        this.log("ejbActivate (" + this.id() + ")");
    }

    public String ejbCreate(String string, double d) throws CreateException {
        this.log("AccountBean.ejbCreate( id = accountId, initial balance = $ " + d + ")");
        this.accountId = string;
        this.balance = d;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement("insert into ejbAccounts (id, bal) values (?, ?)");
                preparedStatement.setString(1, string);
                preparedStatement.setDouble(2, this.balance);
                if (preparedStatement.executeUpdate() != 1) {
                    String string2 = "JDBC did not create any row";
                    this.log(string2);
                    throw new CreateException(string2);
                }
                String string3 = string;
                Object var8_8 = null;
                this.cleanup(connection, preparedStatement);
                return string3;
            }
            catch (SQLException sQLException) {
                try {
                    this.ejbFindByPrimaryKey(string);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    String string4 = "SQLException: " + sQLException;
                    this.log(string4);
                    throw new CreateException(string4);
                }
                String string5 = "An Account already exists in the database with Primary Key " + string;
                this.log(string5);
                throw new DuplicateKeyException(string5);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.cleanup(connection, preparedStatement);
            throw throwable;
        }
    }

    public Enumeration ejbFindBigAccounts(double d) {
        this.log("ejbFindBigAccounts (balance > " + d + ")");
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement("select id from ejbAccounts where bal > ?");
                preparedStatement.setDouble(1, d);
                preparedStatement.executeQuery();
                ResultSet resultSet = preparedStatement.getResultSet();
                Vector<String> vector = new Vector<String>();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    vector.addElement(string);
                }
                Enumeration enumeration = vector.elements();
                Object var7_9 = null;
                this.cleanup(connection, preparedStatement);
                return enumeration;
            }
            catch (SQLException sQLException) {
                this.log("SQLException: " + sQLException);
                throw new EJBException((Exception)sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.cleanup(connection, preparedStatement);
            throw throwable;
        }
    }

    public String ejbFindByPrimaryKey(String string) throws ObjectNotFoundException {
        this.log("ejbFindByPrimaryKey (" + string + ")");
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement("select bal from ejbAccounts where id = ?");
                preparedStatement.setString(1, string);
                preparedStatement.executeQuery();
                ResultSet resultSet = preparedStatement.getResultSet();
                if (!resultSet.next()) {
                    String string2 = "ejbFindByPrimaryKey: AccountBean (" + string + ") not found";
                    this.log(string2);
                    throw new ObjectNotFoundException(string2);
                }
                this.balance = resultSet.getDouble(1);
            }
            catch (SQLException sQLException) {
                this.log("SQLException:  " + sQLException);
                throw new EJBException((Exception)sQLException);
            }
            Object var5_7 = null;
            this.cleanup(connection, preparedStatement);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.cleanup(connection, preparedStatement);
            throw throwable;
        }
        this.log("ejbFindByPrimaryKey (" + string + ") found");
        return string;
    }

    public String ejbHomeHomyMethod() {
        String string = "Sample: AccountBean.ejbHomeHomyMethod() invoked";
        System.out.println(string);
        return string;
    }

    public void ejbLoad() {
        this.log("ejbLoad: (" + this.id() + ")");
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        this.accountId = (String)this.ctx.getPrimaryKey();
        try {
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement("select bal from ejbAccounts where id = ?");
                preparedStatement.setString(1, this.accountId);
                preparedStatement.executeQuery();
                ResultSet resultSet = preparedStatement.getResultSet();
                if (!resultSet.next()) {
                    String string = "ejbLoad: AccountBean (" + this.accountId + ") not found";
                    this.log(string);
                    throw new NoSuchEntityException(string);
                }
                this.balance = resultSet.getDouble(1);
            }
            catch (SQLException sQLException) {
                this.log("SQLException:  " + sQLException);
                throw new EJBException((Exception)sQLException);
            }
            Object var4_6 = null;
            this.cleanup(connection, preparedStatement);
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.cleanup(connection, preparedStatement);
            throw throwable;
        }
    }

    public void ejbPassivate() {
        this.log("ejbPassivate (" + this.id() + ")");
    }

    public void ejbPostCreate(String string, double d) {
        this.log("ejbPostCreate (" + this.id() + ")");
    }

    public void ejbRemove() {
        this.log("ejbRemove (" + this.id() + ")");
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getConnection();
                this.accountId = (String)this.ctx.getPrimaryKey();
                preparedStatement = connection.prepareStatement("delete from ejbAccounts where id = ?");
                preparedStatement.setString(1, this.accountId);
                if (preparedStatement.executeUpdate() <= 0) {
                    String string = "AccountBean (" + this.accountId + " not found";
                    this.log(string);
                    throw new NoSuchEntityException(string);
                }
            }
            catch (SQLException sQLException) {
                this.log("SQLException:  " + sQLException);
                throw new EJBException((Exception)sQLException);
            }
            Object var4_5 = null;
            this.cleanup(connection, preparedStatement);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.cleanup(connection, preparedStatement);
            throw throwable;
        }
    }

    public void ejbStore() {
        this.log("ejbStore (" + this.id() + ")");
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement("update ejbAccounts set bal = ? where id = ?");
                preparedStatement.setDouble(1, this.balance);
                preparedStatement.setString(2, this.accountId);
                if (preparedStatement.executeUpdate() <= 0) {
                    String string = "ejbStore: AccountBean (" + this.accountId + ") not updated";
                    this.log(string);
                    throw new NoSuchEntityException(string);
                }
            }
            catch (SQLException sQLException) {
                this.log("SQLException:  " + sQLException);
                throw new EJBException((Exception)sQLException);
            }
            Object var4_5 = null;
            this.cleanup(connection, preparedStatement);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.cleanup(connection, preparedStatement);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Connection getConnection() throws SQLException {
        Connection connection;
        Object object22;
        InitialContext initialContext = null;
        try {
            try {
                initialContext = new InitialContext();
                object22 = (DataSource)initialContext.lookup("java:comp/env/jdbc/demoPool");
                connection = object22.getConnection();
                Object var4_6 = null;
            }
            catch (NamingException namingException) {
                this.log("Failed to lookup JDBC Datasource. Please double check that");
                this.log("the JNDI name defined in the resource-description of the ");
                this.log("EJB's weblogic-ejb-jar.xml file is the same as the JNDI name ");
                this.log("for the Datasource defined in your config.xml.");
                throw new EJBException((Exception)namingException);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                if (initialContext == null) throw throwable;
                initialContext.close();
                throw throwable;
            }
            catch (NamingException namingException) {
                this.log("Error closing context: " + namingException);
                throw new EJBException((Exception)namingException);
            }
        }
        try {}
        catch (NamingException object22) {
            this.log("Error closing context: " + object22);
            throw new EJBException((Exception)object22);
        }
        if (initialContext == null) return connection;
        initialContext.close();
        return connection;
    }

    private String id() {
        return "PK = " + (String)this.ctx.getPrimaryKey();
    }

    private void log(String string) {
        System.out.println(string);
    }

    public void setEntityContext(EntityContext entityContext) {
        this.log("setEntityContext called");
        this.ctx = entityContext;
    }

    public void unsetEntityContext() {
        this.log("unsetEntityContext");
        this.ctx = null;
    }

    public double withdraw(double d) throws ProcessingErrorException {
        this.log("Withdrawing $" + d + " from '" + this.accountId + "'");
        if (d > this.balance) {
            String string = "Request to withdraw $" + d + " more than balance " + this.balance + " in account " + this.accountId;
            this.log(string);
            throw new ProcessingErrorException(string);
        }
        this.balance -= d;
        return this.balance;
    }
}

