/*
 * Decompiled with CFR 0.152.
 */
package examples.cluster.ejb.account;

import examples.cluster.ejb.account.AccountException;
import examples.cluster.ejb.account.AccountPK;
import examples.cluster.ejb.account.AccountResult;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import weblogic.management.Admin;

public class AccountBean
implements EntityBean {
    static final boolean VERBOSE = true;
    static final int SLEEP = 3000;
    private EntityContext ctx;
    private transient String serverName;
    public String accountId;
    public double balance;

    public AccountResult balance() {
        System.out.println("AccountBean.balance (" + this.id() + ")");
        return new AccountResult(this.serverName, this.balance);
    }

    public AccountResult deposit(double d) {
        System.out.println("AccountBean.deposit ($" + d + " into '" + this.accountId + "', " + this.id() + ")");
        this.balance += d;
        return new AccountResult(this.serverName, this.balance);
    }

    public void ejbActivate() {
        System.out.println("AccountBean.ejbActivate (" + this.id() + ")");
    }

    public AccountPK ejbCreate(String string, double d) throws CreateException {
        System.out.println("AccountBean.ejbCreate( id = " + System.identityHashCode(this) + ", PK = " + string + ", " + "initial balance = $ '" + d + ")");
        this.accountId = string;
        this.balance = d;
        return null;
    }

    public void ejbLoad() {
        System.out.println("AccountBean.ejbLoad (" + this.id() + ")");
    }

    public void ejbPassivate() {
        System.out.println("AccountBean.ejbPassivate (" + this.id() + ")");
    }

    public void ejbPostCreate(String string, double d) {
        System.out.println("AccountBean.ejbPostCreate (" + this.id() + ")");
    }

    public void ejbRemove() throws RemoveException {
        System.out.println("AccountBean.ejbRemove (" + this.id() + ")");
    }

    public void ejbStore() {
        System.out.println("AccountBean.ejbStore (" + this.id() + "): failover test point");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private String getServerName() {
        String string = null;
        try {
            string = Admin.getServerName();
            if (string == null) {
                return "";
            }
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String id() {
        return System.identityHashCode(this) + ", PK = " + (this.ctx == null ? "nullctx" : (this.ctx.getPrimaryKey() == null ? "null" : this.ctx.getPrimaryKey().toString()));
    }

    public void setEntityContext(EntityContext entityContext) {
        System.out.println("AccountBean.setEntityContext (" + this.id() + ")");
        this.ctx = entityContext;
        this.serverName = this.getServerName();
    }

    public void unsetEntityContext() {
        System.out.println("AccountBean.unsetEntityContext");
        this.ctx = null;
    }

    public AccountResult withdraw(double d) throws AccountException {
        System.out.println("AccountBean.withdraw ($" + d + " from '" + this.accountId + "', " + this.id() + ")");
        if (d > this.balance) {
            throw new AccountException("Request to withdraw $" + d + " more than balance " + this.balance + " in account " + this.accountId);
        }
        this.balance -= d;
        return new AccountResult(this.serverName, this.balance);
    }
}

