# This script should be used to set up your environment for 
# compiling and running the examples included with WebLogic 
# Server. It contains the following variables: 
# 
# WL_HOME   - This must point to the root directory of your WebLogic 
#             installation. 
# JAVA_HOME - Determines the version of Java used to compile  
#             and run examples. This variable must point to the 
#             root directory of a complete JDK installation. See 
#             the WebLogic platform support page 
#             (@DOCSHOST/platforms/index.html)
#             for an up-to-date list of supported JVMs on your platform. 
# 
# jDriver for Oracle users: This script assumes that native libraries required 
# for jDriver for Oracle have been installed in the proper location and that 
# your os specific library path variable (i.e. LD_LIBRARY_PATH/solaris, 
# SHLIB_PATH/hpux, etc...) has been set appropriately.  Also note that this 
# script defaults to the oci816_8 version of the shared libraries. If this is 
# not the version you need, please adjust the library path variable 
# accordingly.  

# For additional information, refer to Installing and Setting up WebLogic 
# Server (@DOCSWEBROOT/install/index.html).

# Set user-defined variables.
WL_HOME=/home/nick/weblogic/wlserver6.1; export WL_HOME
JAVA_HOME=/opt/jdk/jdk1.3; export JAVA_HOME

# Check for WebLogic Server classes
if [ ! -f $WL_HOME/lib/weblogic.jar ]; then
  echo "The WebLogic Server was not found in directory $WL_HOME." 1>&2

# Check for JDK
elif [ ! -f $JAVA_HOME/bin/java ]; then
  echo "The JDK was not found in directory $JAVA_HOME." 1>&2
else

APPLICATIONS=$WL_HOME/config/examples/applications; export APPLICATIONS
echo "APPLICATIONS=$APPLICATIONS"
CLIENT_CLASSES=$WL_HOME/config/examples/clientclasses; export CLIENT_CLASSES
echo "CLIENT_CLASSES=$CLIENT_CLASSES"
SERVER_CLASSES=$WL_HOME/config/examples/serverclasses; export SERVER_CLASSES
echo "SERVER_CLASSES=$SERVER_CLASSES"
EX_WEBAPP_CLASSES=$WL_HOME/config/examples/applications/examplesWebApp/WEB-INF/classes; export EX_WEBAPP_CLASSES
echo "EX_WEBAPP_CLASSES=$EX_WEBAPP_CLASSES"

# Figure out how to use our shared libraries
case `uname -s` in
AIX)
  if [ -n "$LIBPATH" ]; then
    LIBPATH=$LIBPATH:$WL_HOME/lib/aix:$WL_HOME/lib/aix/oci816_8
  else
    LIBPATH=$WL_HOME/lib/aix:$WL_HOME/lib/aix/oci816_8
  fi
  PATH=$WL_HOME/lib/aix:$PATH
  export AIXTHREAD_SCOPE=S
  export AIXTHREAD_MUTEX_DEBUG=OFF
  export AIXTHREAD_RWLOCK_DEBUG=OFF
  export AIXTHREAD_COND_DEBUG=OFF
  export LIBPATH PATH
  echo "LIBPATH=$LIBPATH"
;;
HP-UX)
  if [ -n "$SHLIB_PATH" ]; then
    SHLIB_PATH=$SHLIB_PATH:$WL_HOME/lib/hpux11:$WL_HOME/lib/hpux11/oci816_8
  else
    SHLIB_PATH=$WL_HOME/lib/hpux11:$WL_HOME/lib/hpux11/oci816_8
  fi
  PATH=$WL_HOME/lib/hpux11:$PATH
  export SHLIB_PATH PATH
  echo "SHLIB_PATH=$SHLIB_PATH"
;;
IRIX)
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/irix
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/irix
  fi
  PATH=$WL_HOME/lib/irix:$PATH
  export LD_LIBRARY_PATH PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
LINUX|Linux)
  arch=`uname -m`
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/linux/$arch:$WL_HOME/lib/linux/$arch/oci816_8
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/linux/$arch:$WL_HOME/lib/linux/$arch/oci816_8
  fi
  PATH=$WL_HOME/lib/linux:$PATH
  export LD_LIBRARY_PATH PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
OSF1)
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/tru64unix:$WL_HOME/lib/tru64unix/oci816_8
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/tru64unix:$WL_HOME/lib/tru64unix/oci816_8
  fi
  PATH=$WL_HOME/lib/tru64unix:$PATH
  export LD_LIBRARY_PATH PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
SunOS)
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/solaris:$WL_HOME/lib/solaris/oci816_8
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/solaris:$WL_HOME/lib/solaris/oci816_8
  fi
  PATH=$WL_HOME/lib/solaris:$PATH
  export LD_LIBRARY_PATH PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
*)
  echo "$0: Don't know how to set the shared library path for `uname -s`.  "
esac

CLASSPATH=$JAVA_HOME/lib/tools.jar:$WL_HOME/lib/weblogic_sp.jar:$WL_HOME/lib/weblogic.jar:$WL_HOME/lib/xmlx.jar:$WL_HOME/samples/eval/cloudscape/lib/cloudscape.jar:$CLIENT_CLASSES:$SERVER_CLASSES:$EX_WEBAPP_CLASSES:/home/nick/weblogic
export CLASSPATH
echo "CLASSPATH=$CLASSPATH"

PATH=$WL_HOME/bin:$JAVA_HOME/jre/bin:$JAVA_HOME/bin:$PATH
export PATH
echo "PATH=$PATH"

echo ""
echo "Your environment has been set."

fi

