#!/bin/sh
# $Id$
#
# This script can be used to start WebLogic Server for the purpose
# of running the petstore. This script ensures that the server is started
# using the config.xml file found in this directory and that the CLASSPATH
# is set appropriately. This script contains the following variables:
#
# WL_HOME        - The root directory of your WebLogic Server
#                  installation
# JAVA_HOME      - Determines the version of Java used to start
#                  WebLogic Server. This variable must point to the
#                  root directory of a JDK installation and will be set
#                  for you by the WebLogic Server installer.
#                  See the WebLogic platform support
#                  page (@DOCSHOST/platforms/index.html)
#                  for an up-to-date list of supported JVMs on your platform.
# JAVA_OPTIONS   - Java command-line options for running the server.
#
# jDriver for Oracle users: This script assumes that native libraries required 
# for jDriver for Oracle have been installed in the proper location and that 
# your os specific library path variable (i.e. LD_LIBRARY_PATH/solaris, 
# SHLIB_PATH/hpux, etc...) has been set appropriately.  Also note that this 
# script defaults to the oci816_8 version of the shared libraries. If this is 
# not the version you need, please adjust the library path variable 
# accordingly.  

# For additional information, refer to Installing and Setting up WebLogic 
# Server (@DOCSWEBROOT/install/index.html).

# Set user-defined variables.
JAVA_HOME=/opt/jdk/jdk1.3
WL_HOME=/home/nick/weblogic/wlserver6.1
JAVA_OPTIONS="-ms64m -mx64m"

# Check that script is being run from the appropriate directory
if [ ! -f config.xml ]; then
  echo "startPetStore.sh: must be run from the config/petstore directory." 1>&2

# Check for classes
elif [ ! -f $WL_HOME/lib/weblogic.jar ]; then
  echo "The weblogic.jar file was not found in directory $WL_HOME/lib." 1>&2

# Check for JDK
elif [ ! -f $JAVA_HOME/bin/javac ]; then
  echo "The JDK wasn't found in directory $JAVA_HOME." 1>&2

else

cd ../..

# Grab some file descriptors.
if [ "`uname -s`" != "OSF1" ]; then
  maxfiles=`ulimit -H -n`
else
  maxfiles=`ulimit -n`
fi
if [ !$? -a "$maxfiles" != 1024 ]; then
  if [ "$maxfiles" = "unlimited" ]; then
    maxfiles=1025
  fi
  if [ "$maxfiles" -lt 1024 ]; then
    ulimit -n $maxfiles
  else
    ulimit -n 1024
  fi
fi

# Figure out how to use our shared libraries
case `uname -s` in
AIX)
  if [ -n "$LIBPATH" ]; then
    LIBPATH=$LIBPATH:$WL_HOME/lib/aix:$WL_HOME/lib/aix/oci816_8
  else
    LIBPATH=$WL_HOME/lib/aix:$WL_HOME/lib/aix/oci816_8
  fi
  JAVA_OPTIONS="-Djava.security.auth.login.config=$WL_HOME/lib/aix/.java.login.config $JAVA_OPTIONS"
  PATH=$WL_HOME/lib/aix:$PATH
  export LIBPATH PATH
  export AIXTHREAD_SCOPE=S
  export AIXTHREAD_MUTEX_DEBUG=OFF
  export AIXTHREAD_RWLOCK_DEBUG=OFF
  export AIXTHREAD_COND_DEBUG=OFF
  echo "LIBPATH=$LIBPATH"
;;
HP-UX)
  if [ -n "$SHLIB_PATH" ]; then
    SHLIB_PATH=$SHLIB_PATH:$WL_HOME/lib/hpux11:$WL_HOME/lib/hpux11/oci816_8
  else
    SHLIB_PATH=$WL_HOME/lib/hpux11:$WL_HOME/lib/hpux11/oci816_8
  fi
  PATH=$WL_HOME/lib/hpux11:$PATH
  export SHLIB_PATH PATH
  echo "SHLIB_PATH=$SHLIB_PATH"
;;
IRIX)
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/irix
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/irix
  fi
  PATH=$WL_HOME/lib/irix:$PATH
  export LD_LIBRARY_PATH PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
LINUX|Linux)
  arch=`uname -m`
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/linux/$arch:$WL_HOME/lib/linux/$arch/oci816_8
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/linux/$arch:$WL_HOME/lib/linux/$arch/oci816_8
  fi
  PATH=$WL_HOME/lib/linux:$PATH
  export LD_LIBRARY_PATH PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
OSF1)
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/tru64unix:$WL_HOME/lib/tru64unix/oci816_8
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/tru64unix:$WL_HOME/lib/tru64unix/oci816_8
  fi
  PATH=$WL_HOME/lib/tru64unix:$PATH
  export LD_LIBRARY_PATH PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
SunOS)
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/solaris:$WL_HOME/lib/solaris/oci816_8
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/solaris:$WL_HOME/lib/solaris/oci816_8
  fi
  PATH=$WL_HOME/lib/solaris:$PATH
  export LD_LIBRARY_PATH PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
  JAVA_OPTIONS="-hotspot $JAVA_OPTIONS"
;;
*)
  echo "$0: Don't know how to set the shared library path for `uname -s`.  "
esac

CLASSPATH=$WL_HOME:$WL_HOME/lib/weblogic_sp.jar:$WL_HOME/lib/weblogic.jar:$WL_HOME/samples/eval/cloudscape/lib/cloudscape.jar:$WL_HOME/config/petstore/serverclasses

PATH=$WL_HOME/bin:$JAVA_HOME/jre/bin:$JAVA_HOME/bin:$PATH

echo
echo "***************************************************"
echo "*  To start WebLogic Server, use the password     *"
echo "*  assigned to the system user.  The system       *"
echo "*  username and password must also be used to     *"
echo "*  access the WebLogic Server console from a web  *"
echo "*  browser.                                       *"
echo "***************************************************"

# Set WLS_PW equal to your system password for no password prompt server startup.
WLS_PW=

java $JAVA_OPTIONS -classpath $CLASSPATH -Dweblogic.Domain=petstore -Dweblogic.Name=petstoreServer -Dweblogic.management.password=$WLS_PW -Dbea.home=/home/nick/weblogic -Dcloudscape.system.home=./samples/eval/cloudscape/data -Djava.security.policy==$WL_HOME/lib/weblogic.policy weblogic.Server

cd config/petstore

fi
