#!/bin/sh
# $Id$
#
# This script can be used to start Node Manager. This script ensures
# that the Node Manager is started in the root directory of the installation
# and that the CLASSPATH is set correctly. This script contains
# the following variables:
#
# WL_HOME        - The root directory of your WebLogic Server
#                  installation
# JAVA_HOME      - Determines the version of Java used to start
#                  Node Manager. This variable must point to the
#                  root directory of a JDK installation. See
#                  the WebLogic platform support page
#                  (@DOCSHOST/platforms/index.html)
#                  for an up-to-date list of supported JVMs on your platform.
#

# Set user-defined variables.
JAVA_HOME=/opt/jdk/jdk1.3
WL_HOME=/home/nick/weblogic/wlserver6.1

# The next line assumes that this script has been installed and is
# started in the WL_HOME/config directory
cd ..

# Check that script is being run from the appropriate directory
if [ ! -f lib/weblogic.jar ]; then
  echo "startWeblogic.sh: must be run from the /home/nick/weblogic/wlserver6.1/config directory." 1>&2

# Check for JDK
elif [ ! -f $JAVA_HOME/bin/javac ]; then
  echo "The JDK wasn't found in directory $JAVA_HOME." 1>&2

else

# Figure out how to use our shared libraries
case `uname -s` in
AIX)
  if [ -n "$LIBPATH" ]; then
    LIBPATH=$LIBPATH:$WL_HOME/lib/aix:$WL_HOME/lib/aix/oci816_8
  else
    LIBPATH=$WL_HOME/lib/aix:$WL_HOME/lib/aix/oci816_8
  fi
  export LIBPATH
  echo "LIBPATH=$LIBPATH"
  export AIXTHREAD_SCOPE=S
  export AIXTHREAD_MUTEX_DEBUG=OFF
  export AIXTHREAD_RWLOCK_DEBUG=OFF
  export AIXTHREAD_COND_DEBUG=OFF
;;
HP-UX)
  if [ -n "$SHLIB_PATH" ]; then
    SHLIB_PATH=$SHLIB_PATH:$WL_HOME/lib/hpux11:$WL_HOME/lib/hpux11/oci816_8
  else
    SHLIB_PATH=$WL_HOME/lib/hpux11:$WL_HOME/lib/hpux11/oci816_8
  fi
  export SHLIB_PATH
  echo "SHLIB_PATH=$SHLIB_PATH"
;;
IRIX)
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/irix
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/irix
  fi
  export LD_LIBRARY_PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
LINUX|Linux)
  arch=`uname -m`
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/linux/$arch:$WL_HOME/lib/linux/$arch/oci816_8
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/linux/$arch:$WL_HOME/lib/linux/$arch/oci816_8
  fi
  export LD_LIBRARY_PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
OSF1)
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/tru64unix:$WL_HOME/lib/tru64unix/oci816_8
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/tru64unix:$WL_HOME/lib/tru64unix/oci816_8
  fi
  export LD_LIBRARY_PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
SunOS)
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/solaris
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/solaris
  fi
  export LD_LIBRARY_PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
*)
  echo "$0: Don't know how to set the shared library path for `uname -s`.  "
esac

CLASSPATH=$WL_HOME:$WL_HOME/lib/weblogic_sp.jar:$WL_HOME/lib/weblogic.jar:/home/nick/weblogic

PATH=$WL_HOME/bin:$JAVA_HOME/jre/bin:$JAVA_HOME/bin:$PATH

java -ms16m -mx16m -classpath $CLASSPATH -Djava.security.policy==/home/nick/weblogic/wlserver6.1/lib/weblogic.policy -Dweblogic.nodemanager.weblogicHome=/home/nick/weblogic/wlserver6.1 weblogic.nodemanager.NodeManager

fi






