package examples.cluster.ejb.account;

import java.rmi.RemoteException;
import javax.ejb.*;

/**
 * The methods in this interface are the public face of AccountBean.
 * The signatures of the methods are identical to those of the bean, 
 * except that these methods throw a java.rmi.RemoteException.
 * Note that the EJBean does not implement this interface. 
 * The corresponding code-generated EJBObject implements this interface
 * and delegates to the EJBean.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface Account extends EJBObject {

  /**
   * Balance in account.
   *
   * @return                  AccountResult account result
   * @exception               java.rmi.RemoteException if there is
   *                          a communications or systems failure
   */
  public AccountResult balance() 
    throws RemoteException;

  /**
   * Deposits an amount.
   *
   * @param amount            double amount to deposit
   * @return AccountResult    Account result
   * @exception               java.rmi.RemoteException if there is
   *                          a communications or systems failure
   */
  public AccountResult deposit(double amount)
    throws RemoteException;

  /**
   * Withdraws an amount.
   *
   * @param amount            double amount to withdraw
   * @return AccountResult    Account result
   * @exception               examples.cluster.ejb.account.AccountException
   *                          if there is an error while depositing
   * @exception               java.rmi.RemoteException if there is
   *                          a communications or systems failure
   */
  public AccountResult withdraw(double amount)
    throws AccountException, RemoteException;
}
