package examples.cluster.ejb.account;

import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * This interface is the home interface for the EJBean AccountBean,
 * which in WebLogic is implemented by the code-generated container class 
 * AccountBeanC. A home interface may support one or more create methods,
 * which must correspond to methods named "ejbCreate" in the EJBean.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface AccountHome extends EJBHome {

  /**
   * This method corresponds to the ejbCreate method in the bean
   * "AccountBean.java".
   * The parameter sets of the two methods are identical.  When the client calls
   * <code>AccountHome.create()</code>, the container (which in WebLogic EJB is
   * also the factory) allocates an instance of the bean and
   * calls <code>AccountBean.ejbCreate()</code>.
   *
   * For container-managed persistence, <code>ejbCreate()</code>  
   * returns a void, unlike the case of bean-managed 
   * persistence, where it returns a primary key.
   *
   * @param accountId         string account ID
   * @param initialBalance    double initial balance
   * @return                  Account
   * @exception               javax.ejb.CreateException
   *                          if there is an error creating the bean
   * @exception               java.rmi.RemoteException if there is
   *                          a communications or systems failure
   * @see                     examples.cluster.ejb.account.AccountBean
   */
  public Account create(String accountId, double initialBalance) 
    throws CreateException, RemoteException;

  /**
   * Given a Primary Key, refreshes the EJBean from
   * the persistent storage.
   *
   * @param primaryKey        AccountPK primary Key
   * @return                  Account
   * @exception               javax.ejb.FinderException
   *                          if there is an error finding the bean
   * @exception               java.rmi.RemoteException if there is
   *                          a communications or systems failure
   * @see                     examples.cluster.ejb.account.AccountBean
   */
  public Account findByPrimaryKey(AccountPK primaryKey) 
    throws FinderException, RemoteException;

}
