package examples.cluster.ejb.account;

/**
 * This class is used to return information and the results of a 
 * balance inquiry, deposit, withdrawal or transfer transaction.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public final class AccountResult implements java.io.Serializable {
  public String server  = null; // The weblogic.system.name added to
                                // demonstrate clustering
  public double balance = 0;


  /**
   * Default AccountResult object creator.
   *
   * @return                  AccountResult
   */
  public AccountResult() {
  }

  /**
   * Creates an AccountResult object with
   * the server (the name of the Cluster member) where the EJBean is located 
   * and the account balance.
   *
   * @param server            string server name (the cluster member)
   * @param balance           double account balance
   * @return                  AccountResult
   */
  public AccountResult(String server, double balance) {
    this.server  = server;
    this.balance = balance;
  }

  /**
   * Returns the server name
   * from an AccountResult object.
   *
   * @return                  String server name
   */
  public String getServer() {
    return server;
  }

  /**
   * Returns the account balance
   * from an AccountResult object.
   *
   * @return                  Double account balance
   */
  public double getBalance() {
    return balance;
  }
}
