package examples.cluster.ejb.teller;

import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * The methods in this interface are the public face of TellerBean.
 * The signatures of the methods are identical to those of the EJBean, except
 * that these methods throw a java.rmi.RemoteException.
 * Note that the EJBean does not implement this interface. The corresponding
 * code-generated EJBObject, TellerBeanE, implements this interface and
 * delegates to the bean.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface Teller extends EJBObject {

  /**
   * Returns the balance of the account in a TellerResult object.
   *
   * @param accountId         string account ID
   * @return                  TellerResult result of inquiry
   * @exception               examples.cluster.ejb.teller.TellerException
   *                          if there is an error while checking the balance
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public TellerResult balance(String accountId)
    throws TellerException, RemoteException;

  /**
   * Deposits amount in specified account using a specific transaction ID.
   *
   * @param accountId         string account ID
   * @param amount            double amount to deposit
   * @param transactionId     string transaction ID
   * @return                  TellerResult result of inquiry
   * @exception               examples.cluster.ejb.teller.TellerException
   *                          if there is an error while making the deposit
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public  TellerResult deposit(String accountId, double amount, String transactionId)
    throws TellerException, RemoteException;

  /**
   * Withdraws amount from specified account using a specific transaction ID.
   *
   * @param accountId         string account ID
   * @param amount            double amount to withdraw
   * @param transactionId     string transaction ID
   * @return                  TellerResult result of inquiry
   * @exception               examples.cluster.ejb.teller.TellerException
   *                          if there is an error while making the withdrawal
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public TellerResult withdraw (String accountId, double amount, String transactionId)
    throws TellerException, RemoteException;

  /**
   * Transfers amount from accountFrom to accountTo using a specific transaction ID.
   *
   * @param accountFrom       string account ID of account taking amount from
   * @param accountTo         string account ID of account sending amount to
   * @param amount            double amount to transfer
   * @param transactionId     string transaction ID
   * @return                  TellerResult result of inquiry
   * @exception               examples.cluster.ejb.teller.TellerException
   *                          if there is an error while making the transfer
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public TellerResult transfer(String accountFromId, String accountToId, double amount, String transactionId)
    throws TellerException, RemoteException;

  /**
   * Returns <tt>true</tt> if the transaction with a given
   * ID was completed (i.e., the transaction ID can be found
   * in the transaction log table).
   * <p>
   * Note that the code in this method is specific for Oracle
   * databases and will require adjustment for other databases.
   *
   * @param transactionID     string transaction ID
   * @return                  Boolean
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public boolean checkTransactionId(String transactionId)
    throws RemoteException;
}
