package examples.cluster.ejb.teller;

import java.io.Serializable;
import examples.cluster.ejb.account.AccountResult;

/**
 * This class reflects the results of a deposit, withdrawal, or transfer transaction.
 * Results are for account 1, account 2, and the server the teller was on.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public final class TellerResult implements java.io.Serializable {
  public String        tellerServer   = null; // The weblogic.system.name added to
                                              // demonstrate clustering
  public AccountResult account1Result = new AccountResult();
  public AccountResult account2Result = new AccountResult();

  /**
   * Creates a new TellerResult object.
   *
   * @return                  TellerResult
   */
  public TellerResult() {
  }

  /**
   * Creates a new TellerResult object.
   *
   * @param tellerServer      String Teller server name (the Cluster member)
   * @param account1Result    AccountResult account 1 result
   * @return                  TellerResult
   */
  public TellerResult(String tellerServer, AccountResult accountResult) {
    this.tellerServer    = tellerServer;
    if (accountResult != null) {
      this.account1Result = accountResult;
    }
  }

  /**
   * Creates a new TellerResult object.
   *
   * @param tellerServer      String Teller server name (the Cluster member)
   * @param account1Result    AccountResult account 1 result
   * @param account2Result    AccountResult account 2 result
   * @return                  TellerResult
   */
  public TellerResult(String tellerServer, AccountResult account1Result, 
      AccountResult account2Result) {
    this.tellerServer = tellerServer;
    if (account1Result != null) {
      this.account1Result = account1Result;
    }
    if (account2Result != null) {
      this.account2Result = account2Result;
    }
  }

  /**
   * Returns the teller server name.
   *
   * @return String           Teller server name
   */
  public String getTellerServer() {
    return tellerServer;
  }

  /**
   * Returns the results for account 1
   * in an AccountResult object.
   *
   * @return AccountResult    Results for account 1
   */
  public AccountResult getAccount1Result() {
    return account1Result;
  }

  /**
   * Returns the results for account 2
   * in an AccountResult object.
   *
   * @return AccountResult    Results for account 2
   */
  public AccountResult getAccount2Result() {
    return account2Result;
  }
}
