package examples.cluster.rmi;

import java.rmi.RemoteException;
import weblogic.jndi.Environment;
import weblogic.jndi.WLInitialContextFactory;

import javax.naming.*;

import examples.cluster.utils.ClusterUtils;


/**
 * Client for simple clustered RMI service example.
 *
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class HelloClusterClient {
  private HelloCluster hello;
  private static String usage = "java examples.cluster.rmi.HelloClusterClient [-options]\n\n"
  +"where options are:\n"
  +"    -url        URL of a WebLogic Server, can be any member of a Cluster\n"
  +"    -i          Number of iterations to execute, default is 10\n"
  +"    -noverbose  Supresses responses from RMI Object\n"
  +"    -help       This message";
    private boolean verbose = true;
  public static String url = null;
  public static int iterations = 10;

  
  public String hello() throws RemoteException{
    return hello.sayHello();
  }
  
  public static int getIterations(){
    return iterations;
  }
  /**
   * Constructor takes an array of args, gets an initial context, and gets
   * a remote reference to an RMI object.
   */
  public HelloClusterClient(String[] args) throws NamingException {
    if ((args.length == 0)){
      exit();
    }
    for (int i = 0; i < args.length; i++) {
      try{
	  if (args[i].equals("-url") && (i+1 < args.length))
	      url = args[++i];

	  else if (args[i].equals("-i") && (i+1 < args.length)) 
	      iterations = Integer.parseInt(args[++i]);
	  else if (args[i].equalsIgnoreCase("-noverbose")) 
	      verbose = false;
	  else if (args[i].equalsIgnoreCase("-h") || (args[i].equals("-help"))){
	      exit();
	  }
      }catch(NumberFormatException e){
	exit();
      }
    }
    if(url==null){
      exit();
    }
    // get a naming context from the cluster using convenience classes
    Environment env = new Environment();
    env.setProviderUrl(url);
    Context context = env.getInitialContext();
    // lookup the RMI service
    hello = (HelloCluster)context.lookup(HelloClusterImpl.BINDNAME);
  }  
  
  /**
   * Creates a Trade object and performs a specified number of
   * random trades on it.
   */
  public static void main(String inArgs[]) {
    HelloClusterClient client = null;
    ClusterUtils utils = null;
    try {
      client = new HelloClusterClient(inArgs);
    } catch(NamingException e) {
      System.out.println("Exception with server: " + url);
      e.printStackTrace();
      return;
    } 
    utils = new ClusterUtils();
    for(int i=0; i<getIterations(); i++) {
      try {
	String returnHello = client.hello();
	if(client.verbose)
	  System.out.println(returnHello);
	utils.addClusterMessage(returnHello);
	  //	Thread.sleep(200); // pause for clarity
      } catch(Exception e) {
	  e.printStackTrace();
	utils.incrementExceptionCount();
      }
    }
    System.out.println("\nCompleted " + utils.getIterations() + 
                       " iterations with " + utils.getExceptionCount() + 
                       " number of exceptions.");
    System.out.println("\nNow processing aggregate results.\n\n");
    System.out.println(utils.processStatistics());
  }

    private void exit(){
      System.out.println(usage);
      System.exit(-1);
    }
}
