package examples.cluster.rmi;

import javax.naming.*;
import weblogic.jndi.*;
import weblogic.management.Admin;
import weblogic.common.*;
import java.util.Hashtable;

/**
 * This class implements the interface HelloCluster.
 *  
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class HelloClusterImpl implements HelloCluster{   
  public static final String BINDNAME = "HelloCluster";

  /**
   * Returns a string.
   *
   * @return                  String message
   * @exception               java.rmi.RemoteException
   */
  public String sayHello() throws java.rmi.RemoteException {
    String temp =  "Hello World from : " + getLocation();
    System.out.println(temp);
    return temp;
  }
  
  private String getLocation(){
    String toReturn = null;
    try{
    toReturn = weblogic.management.Admin.getServerName();
    }catch(Exception e){
      System.out.println("HelloClusterImpl failed getLocation");
      e.printStackTrace();
    }
    if(toReturn==null){
      return "";
    }else{
      return toReturn;
    }
  }
  /**
   * Allows the WebLogic Server to instantiate this implementation
   * and bind it in the registry.
   */
  public static void main(String args[]) {
    try {
      Context context = new InitialContext();
      context.bind(BINDNAME,new HelloClusterImpl());
      System.out.println("\n\n===========================HelloClusterImpl bound " +BINDNAME+
	  "===========================\n\n");
    } catch(NamingException e) {
      System.out.println("Could not bind service to '"+BINDNAME+"'");
      e.printStackTrace();
    }
  }
}





