package examples.ejb.extensions.readMostly;

/**
 * StockWriterBean is an EntityBean. This EJBean illustrates:
 * <ul>
 * <li> Extending a read-only EJB to provide read-write capability.
 * </ul>
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class StockWriterBean extends StockBean {

  public String ejbCreate(String symbol, double price, long volume)
  {
    this.symbol      = symbol;
    this.price       = price;
    this.volume      = volume;

    yearHigh         = price;
    yearLow          = price;

    return null;
  }

  public void ejbPostCreate(String symbol, double price, long volume)
  {
  }
  
  public void updateStock(double price, long volume) {
    this.price = price;
    this.volume = volume;

    if (price < yearLow) yearLow = price;
    if (price > yearHigh) yearHigh = price;
  }

  

}
