package examples.ejb.subclass;

/**
 * ChildBean is a stateless SessionBean. This bean illustrates:
 * <ul>
 * <li> Extending the functionality of the ParentBean class
 * <li> Overloading methods inherited from the ParentBean class
 * </ul>
 *
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class ChildBean extends ParentBean {

  /**
   * Returns a message identifying the method.
   * This method is unique to the ChildBean.
   *
   * @return                  String Message
   */
  public String childOnlyMethod() {
    return "ChildBean's childOnlyMethod called";
  }

  /**
   * Returns a message identifying the method.
   * This method is inherited and overloaded by the Child bean.
   *
   * @return                  String Message
   */
  public String sayHello() {
    return "Hello from the ChildBean";
  }

}
