package examples.ejb.subclass;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;

/**
 * This interface is the home interface for the ChildBean.java,
 * which in WebLogic is implemented by the code-generated container
 * class ChildBeanC. A home interface may support one or more create
 * methods, which must correspond to methods named "ejbCreate" in the EJBean.
 *
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface ChildHome extends EJBHome {

  /**
   * This method corresponds to the ejbCreate method in the bean
   * "ChildBean.java".
   * Because of ChildBean is subclassed from ParentBean, the method
   * will be found in "ParentBean.java".
   * <p>
   * The parameter sets of the two methods are identical. When the client calls
   * <code>ChildHome.create()</code>, the container
   * allocates an instance of the EJBean and calls <code>ejbCreate()</code>
   * in the class ParentBean.
   *
   * @return                  Parent
   * @exception               CreateException if there is
   *                          a problem creating the bean
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   * @see                     examples.ejb.subclass.parent.ParentBean
   */
  Child create() throws CreateException, RemoteException;
}
