package examples.ejb.subclass;

import java.rmi.RemoteException;
import javax.ejb.EJBObject;

/**
 * The methods in this interface are the public face of ParentBean.
 * The signatures of the methods are identical to those of the EJBean, except
 * that these methods throw a java.rmi.RemoteException.
 * Note that the EJBean does not implement this interface. The corresponding
 * code-generated EJBObject, ParentBeanE, implements this interface and
 * delegates to the bean.
 *
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface Parent extends EJBObject {

  /**
   * Sends back a pre-defined message identifying the method.
   * This method is inherited and overloaded by the Child bean.
   *
   * @return                  String Message
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public String sayHello()
    throws RemoteException;

  /**
   * Sends back a pre-defined message identifying the method.
   * This method is inherited but not overloaded by the Child bean. 
   * 
   * @return                  String Message
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public String nonOverloadedMethod()
    throws RemoteException;

}
