package examples.ejb.subclass;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * ParentBean is a stateless SessionBean. This bean:
 * <ul>
 * <li> Is the parent class to the ChildBean subclass
 * <li> Contains methods that are inherited by the Child bean
 * <li> Contains a method that is overloaded by the Child bean
 * <li> Illustrates the use of protected instead of private variables
 * so that the Child bean can inherit them
 * </ul>
 *
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class ParentBean implements SessionBean {

  static final boolean VERBOSE = true;

  protected SessionContext ctx;

  /**
   * Sets the session context.
   *
   * @param ctx               SessionContext Context for session
   */
  public void setSessionContext(SessionContext ctx) {
    log("setSessionContext called");
    this.ctx = ctx;
  }

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   *
   */
  public void ejbActivate() {
    log("ejbActivate called");
  }

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   *
   */
  public void ejbPassivate() {
    log("ejbPassivate called");
  }

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   *
   */
  public void ejbRemove() {
    log("ejbRemove called");
  }

  /**
   * This method corresponds to the create method in the home interface
   * "ParentHome".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>ParentHome.create()</code>, the container allocates an instance of
   * the EJBean and calls <code>ejbCreate()</code>.
   *
   * @exception               javax.ejb.CreateException if there is
   *                          a problem creating the bean
   * @see                     examples.ejb.subclass.parent.Parent
   */
  public void ejbCreate() throws CreateException {
    log("ejbCreate called");
  }

  /**
   * Sends back a pre-defined message identifying the method.
   * This method is inherited and overloaded by the Child bean.
   *
   * @return                  String Message
   */
  public String sayHello() {
    return "Hello from the ParentBean.";
  }

  /**
   * Sends back a pre-defined message identifying the method.
   * This method is inherited but not overloaded by the Child bean. 
   * 
   * @return                  String Message
   */
  public String nonOverloadedMethod() {
    return "ParentBean's nonOverloadedMethod called";
  }

  protected void log(String s) {
    if(VERBOSE) {
      System.out.println(s);
    }
  }
}
