package examples.ejb20.cascadeDelete.one2many;

import java.util.Collection;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBLocalHome;
import javax.ejb.FinderException;

/**
 * This interface is the home interface for the EJBean CustomerBean.
 * A home interface may support one or more create methods,
 * which must correspond to methods named "ejbCreate" in the EJBean.
 *
 * @author Copyright (c) 1998-2000 by BEA Systems, Inc. All Rights Reserved.
 */
public interface CustomerHome extends EJBLocalHome {

  /**
   * This method corresponds to the ejbCreate method in the bean
   * "CustomerBean.java".
   * The parameter sets of the two methods are identical.  When the client calls
   * <code>AccountHome.create()</code>, the container (which in WebLogic EJB is
   * also the factory) allocates an instance of the bean and
   * calls <code>CustomerBean.ejbCreate()</code>
   */
  public Customer create(String name, int age, Integer level, java.sql.Date lastDate)
    throws CreateException;

  /**
   * Given a Primary Key, refreshes the EJBean from
   * the persistent storage.
   * @param primaryKey        Primary Key
   * @return                  Customer
   * @exception               javax.ejb.FinderException
   *                          if there is an error finding the bean
   * @exception               java.rmi.RemoteException if there is
   *                          a communications or systems failure
   */
  public Customer findByPrimaryKey(String primaryKey)
    throws FinderException;

}
