#include <stdlib.h>
#include <iostream.h>
#include "CosNaming_c.hh"
#include "client_c.hh"

class TradeResultImpl : public virtual ::examples::iiop::ejb::stateless::server::wls::OBV_TradeResult,
                  public virtual CORBA::DefaultValueRefCountBase
{
  public:
  TradeResultImpl() : OBV_TradeResult () {}
  virtual ~TradeResultImpl(){}
  CORBA_ValueBase* _copy_value() {
    return new TradeResultImpl ();
  }
};

class TradeResultFactory: public ::examples::iiop::ejb::stateless::server::wls::TradeResult_init
{
  public:
  TradeResultFactory(){}
  virtual  ~TradeResultFactory(){}

  CORBA::ValueBase*  create_for_unmarshal() {
    return new TradeResultImpl();
  }
};

int main(int argc, char* const* argv)
{
  try {
    CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);

    // string to object
    CORBA::Object_ptr o;

    cout << "Getting name service reference" << endl;
    if (argc >= 2 && strncmp (argv[1], "IOR", 3) == 0)
      o = orb->string_to_object(argv[1]);
    else
      o = orb->resolve_initial_references("NameService");

    orb->register_value_factory("RMI:examples.iiop.ejb.stateless.server.wls.TradeResult:8B2D783A25536FE8:27F05EA5B8CF63DC", (CORBA::ValueFactory)new TradeResultFactory);

    // obtain a naming context
    cout << "Narrowing to a naming context" << endl;
    CosNaming::NamingContext_var context = CosNaming::NamingContext::_narrow(o);
    CosNaming::Name name;
    name.length(1);
    name[0].id = CORBA::string_dup("TraderHome_iiop");
    name[0].kind = CORBA::string_dup("");

    // resolve and narrow to RMI object
    cout << "Resolving the naming context" << endl;
    CORBA::Object_var object = context->resolve(name);

    cout << "Narrowing to the TraderHome" << endl;
    examples::iiop::ejb::stateless::server::wls::TraderHome_var home =
      examples::iiop::ejb::stateless::server::wls::TraderHome::_narrow(object);
     examples::iiop::ejb::stateless::server::wls::Trader_ptr bean = home->create();

    CORBA::WChar* stocks[]={L"BEAS", L"MSFT", L"AMZN", L"HWP", 0};
    for (int i=0; i<4; i++) {
      int shares = (i+1) * 100;
      char    mbc_symbol[20];
      wcstombs( mbc_symbol, stocks[i], 20 );
      cout << "Buying " << shares << " shares of " << mbc_symbol << endl;
      ::CORBA::WStringValue* vl = new ::CORBA::WStringValue(CORBA::wstring_dup(stocks[i]));
      examples::iiop::ejb::stateless::server::wls::TradeResult_var tr = bean->buy(vl, shares);
      vl->_remove_ref();

      wcstombs( mbc_symbol, tr->stockSymbol()->_value(), 20 );
      cout << "Bought " << tr->numberTraded() << " shares of " << mbc_symbol << endl;
    }
  }
  catch(const CORBA::Exception& e) {
    cout << "Failure: " << e << endl;
  }
  return 0;
}

