/*
 * Example Implementation Functions: (Trader_i.cpp)
 * -----------------------------------------------------------------------
 *
 * This module contains example function implementations for the following
 * Implementations:
 *
 *    Trader_i
 *
 */

#include <stdlib.h>
#include "Trader_i.h"
#include "TradeResult_i.h"
#include "TraderHome_c.h"
#include <TP.h>
#include "CosNaming_c.h"
#include <iostream.h>


/*
 *
 *  FUNCTION NAME:       Trader_i
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *     Constructor for Implementation: Trader_i
 *
 */
Trader_i::Trader_i ()
{
}


/*
 *
 *  FUNCTION NAME:       ~Trader_i
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *     Destructor for Implementation: Trader_i
 *
 */
Trader_i::~Trader_i ()
{
}


/*
 *
 *  FUNCTION NAME: 	Trader_i::remove
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for remove.
 *       (Implementation : Trader_i)
 *
 */
void Trader_i::remove ()
{
    return ;
}


/*
 *
 *  FUNCTION NAME: 	Trader_i::isIdentical
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for isIdentical.
 *       (Implementation : Trader_i)
 *
 */
::CORBA::Boolean Trader_i::isIdentical (
    ::javax::ejb::EJBObject_ptr arg0)
{
    ::CORBA::Boolean _method_result = (::CORBA::Boolean) 0;
    return _method_result;
}


/*
 *
 *  FUNCTION NAME: 	Trader_i::buy
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for buy.
 *       (Implementation : Trader_i)
 *
 */
::examples::iiop::ejb::stateless::server::wls::TradeResult * Trader_i::buy (
    ::CORBA::WStringValue * stockSymbol,
    ::CORBA::Long shares)
{
    char    mbc_symbol[20];
    wcstombs( mbc_symbol, stockSymbol->_value(), 20 );

    TP::userlog("Buying %d shares of %s", shares, mbc_symbol);
    ::CORBA::WStringValue* ss = 
        new ::CORBA::WStringValue(CORBA::wstring_dup(stockSymbol->_value()));

    return new examples_iiop_ejb_stateless_server_wls_TradeResult_i(shares, ss);
}

/*
 *
 *  FUNCTION NAME: 	Trader_i::buyRemote
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for buyRemote.
 *       (Implementation : Trader_i)
 *
 */
::examples::iiop::ejb::stateless::server::wls::TradeResult * Trader_i::buyRemote (
    ::CORBA::WStringValue * stockSymbol,
    ::CORBA::Long shares)
{
  examples::iiop::ejb::stateless::server::wls::TradeResult* ret =
    new examples_iiop_ejb_stateless_server_wls_TradeResult_i();
  try {
    // string to object
    CORBA::Object_ptr o;
    
    TP::userlog("Getting name service reference");
    o = TP::bootstrap()->resolve_initial_references("NameService");

    // obtain a naming context
    TP::userlog("Narrowing to a naming context");
    CosNaming::NamingContext_var context = CosNaming::NamingContext::_narrow(o);
    CosNaming::Name name;
    name.length(1);
    name[0].id = CORBA::string_dup("WLS");
    name[0].kind = CORBA::string_dup("");
    
    // resolve and narrow to WLE context
    // Doing this in one step doesn't seem to work
    TP::userlog("Resolving the WLE naming context");
    CORBA::Object_var object = context->resolve(name);
    // resolve and narrow to WLS context
    TP::userlog("Resolving the WLS naming context");
    context = CosNaming::NamingContext::_narrow(object);
    name[0].id = CORBA::string_dup("TraderHome_iiop");
    name[0].kind = CORBA::string_dup("");
    object = context->resolve(name);

    TP::userlog("Narrowing to the Trader Server");
    examples::iiop::ejb::stateless::server::wls::TraderHome_var trhome =
      examples::iiop::ejb::stateless::server::wls::TraderHome::_narrow(object);
    
    TP::userlog("Creating Trader ejb");
    examples::iiop::ejb::stateless::server::wls::Trader_var tr = trhome->create();
    
    char    mbc_symbol[20];
    wcstombs( mbc_symbol, stockSymbol->_value(), 20 );
    TP::userlog("Buying remotely %d shares of %s", shares, mbc_symbol);
    
    ::CORBA::WStringValue* ss = 
        new ::CORBA::WStringValue(CORBA::wstring_dup(stockSymbol->_value()));
    ret = tr->buy(ss, shares);
  }
  catch(const CORBA::Exception& e) {
    TP::userlog("Failure: %s", e.get_id());
  }
  return ret;
}


/*
 *
 *  FUNCTION NAME: 	Trader_i::sell
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for sell.
 *       (Implementation : Trader_i)
 *
 */
::examples::iiop::ejb::stateless::server::wls::TradeResult * Trader_i::sell (
    ::CORBA::WStringValue * stockSymbol,
    ::CORBA::Long shares)
{
    char    mbc_symbol[20];
    wcstombs( mbc_symbol, stockSymbol->_value(), 20 );
    TP::userlog("Selling %d shares of %s", shares, mbc_symbol);
    ::CORBA::WStringValue* ss = 
        new ::CORBA::WStringValue(CORBA::wstring_dup(stockSymbol->_value()));
    return new examples_iiop_ejb_stateless_server_wls_TradeResult_i( shares, ss);
}

/*
 *
 *  FUNCTION NAME: 	Trader_i::sellRemote
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for sellRemote.
 *       (Implementation : Trader_i)
 *
 */
::examples::iiop::ejb::stateless::server::wls::TradeResult * Trader_i::sellRemote (
    ::CORBA::WStringValue * stockSymbol,
    ::CORBA::Long shares)
{
    try {
      // string to object
      CORBA::Object_ptr o;
      
      TP::userlog("Getting name service reference");
      o = TP::bootstrap()->resolve_initial_references("NameService");

      // obtain a naming context
      TP::userlog("Narrowing to a naming context");
      CosNaming::NamingContext_var context = CosNaming::NamingContext::_narrow(o);
      CosNaming::Name name;
      name.length(1);
      name[0].id = CORBA::string_dup("WLS");
      name[0].kind = CORBA::string_dup("");
      
      // resolve and narrow to WLE context
      // Doing this in one step doesn't seem to work
      TP::userlog("Resolving the WLE naming context");
      CORBA::Object_var object = context->resolve(name);
      // resolve and narrow to WLS context
      TP::userlog("Resolving the WLS naming context");
      context = CosNaming::NamingContext::_narrow(object);
      name[0].id = CORBA::string_dup("TraderHome_iiop");
      name[0].kind = CORBA::string_dup("");
      object = context->resolve(name);

      TP::userlog("Narrowing to the Trader Server");
      examples::iiop::ejb::stateless::server::wls::TraderHome_var trhome =
        examples::iiop::ejb::stateless::server::wls::TraderHome::_narrow(object);

      TP::userlog("Creating Trader ejb");
      examples::iiop::ejb::stateless::server::wls::Trader_var tr = trhome->create();
    
    char    mbc_symbol[20];
    wcstombs( mbc_symbol, stockSymbol->_value(), 20 );
    TP::userlog("Selling remotely %d shares of %s", shares, mbc_symbol);

    ::CORBA::WStringValue* ss = 
        new ::CORBA::WStringValue(CORBA::wstring_dup(stockSymbol->_value()));
      return tr->sell(ss, shares);
    }
    catch(const CORBA::Exception& e) {
      TP::userlog("Failure: %s", e.get_id());
    }
    return new examples_iiop_ejb_stateless_server_wls_TradeResult_i();
}


/*
 *
 *  FUNCTION NAME: 	Trader_i::EJBHome
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for EJBHome.
 *       (Implementation : Trader_i)
 *
 */
::javax::ejb::EJBHome_ptr Trader_i::EJBHome ()
{
    ::javax::ejb::EJBHome_ptr _method_result  = ::javax::ejb::EJBHome::_nil();
    return _method_result;
}


/*
 *
 *  FUNCTION NAME: 	Trader_i::handle
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for handle.
 *       (Implementation : Trader_i)
 *
 */
::javax::ejb::Handle_ptr Trader_i::handle ()
{
    ::javax::ejb::Handle_ptr _method_result  = ::javax::ejb::Handle::_nil();
    return _method_result;
}


/*
 *
 *  FUNCTION NAME: 	Trader_i::primaryKey
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for primaryKey.
 *       (Implementation : Trader_i)
 *
 */
::java::lang::Object * Trader_i::primaryKey ()
{
    ::CORBA::Any * _method_result  = new ORBNEWTHROW ::CORBA::Any();
    return _method_result;
}
