/*******************************************************************
 * Created Tue May 01 14:21:36 2001 by Tuxedo V8.0-01 (C++ Bindings)
 *******************************************************************
 */

/*
 * Example Implementation Functions: (Pinger_i.cpp)
 * -----------------------------------------------------------------------
 *
 * This module contains example function implementations for the following
 * Implementations:
 *
 *    Pinger_i
 *
 */

#include <TP.h>
#include "Pinger_i.h"
#include "CosNaming_c.h"
#include <iostream.h>

/*
 *
 *  FUNCTION NAME:       Pinger_i
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *     Constructor for Implementation: Pinger_i
 *
 */
Pinger_i::Pinger_i ()
{
}

/*
 *
 *  FUNCTION NAME:       ~Pinger_i
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *     Destructor for Implementation: Pinger_i
 *
 */
Pinger_i::~Pinger_i ()
{
}

/*
 *
 *  FUNCTION NAME: 	Pinger_i::pingRemote
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for pingRemote.
 *       (Implementation : Pinger_i)
 *
 */
void Pinger_i::pingRemote ()
{
  try {
    // string to object
    CORBA::Object_ptr o;

    TP::userlog("Getting name service reference");
    o = TP::bootstrap()->resolve_initial_references("NameService");

    // obtain a naming context
    TP::userlog("Narrowing to a naming context");
    CosNaming::NamingContext_var context = CosNaming::NamingContext::_narrow(o);
    CosNaming::Name name;
    name.length(1);
    name[0].id = "WLS";
    name[0].kind = "";

    // resolve and narrow to WLE context
    // Doing this in one step doesn't seem to work
    TP::userlog("Resolving the WLE naming context");
    CORBA::Object_var object = context->resolve(name);
    // resolve and narrow to WLS context
    TP::userlog("Resolving the WLS naming context");
    context = CosNaming::NamingContext::_narrow(object);
    name[0].id = "Pinger_iiop";
    name[0].kind = "";
    object = context->resolve(name);

    TP::userlog("Narrowing to the Ping Server");
    examples::iiop::rmi::server::wls::Pinger_var ping =
      examples::iiop::rmi::server::wls::Pinger::_narrow(object);
    
    // ping it
    TP::userlog("Ping (local)");
    ping->ping();
    TP::userlog("Ping (callback)");
    ping->pingCallback(_this());
  }
  catch(const CORBA::Exception& e) {
    TP::userlog("Failure: %s", e.get_id());
  }
}

void Pinger_i::pingCallback (::examples::iiop::rmi::server::wls::Pinger_ptr pinger)
{
  pinger->ping();
}

/*
 *
 *  FUNCTION NAME: 	Pinger_i::pingLocal
 *
 *  FUNCTIONAL DESCRIPTION:
 *
 *      Method function for pingLocal.
 *       (Implementation : Pinger_i)
 *
 */
void Pinger_i::ping ()
{
  TP::userlog("Ping!");
}


