package examples.iiop.rmi.server.wls;

import java.rmi.*;
import javax.naming.*;
import java.util.Properties;
import javax.rmi.PortableRemoteObject;
import weblogic.kernel.Kernel;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;

/**
 * Implements the Ping interface.
 *
 * @author Copyright (c) 2000-2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class PingImpl implements Pinger {
  private static String NAME = "Pinger_iiop";
  private static String remoteDomain = null;
  
  public PingImpl() throws RemoteException {
    super();
  }

  public void ping() throws RemoteException 
  {
    System.out.println("Ping!");
  }

  public void pingRemote() throws RemoteException 
  {
    try {
      InitialContext ctx = new InitialContext();
      Object obj = ctx.lookup(remoteDomain + "/Pinger_iiop");
      Pinger pinger = (Pinger)PortableRemoteObject.narrow(obj, Pinger.class);
      pinger.ping();
    } catch (NamingException ne) {
      ne.printStackTrace();
    }
  }

  public void pingCallback(Pinger toPing) throws RemoteException 
  {
    abstract class Runner implements ExecuteRequest {
      protected Pinger target;
      Runner(Pinger target) { this.target = target; }
    }

    Runner r = new Runner(toPing) 
      {
        public void execute(ExecuteThread thd) throws Exception {
          try {
            target.ping();
          } catch (Throwable th) {
            th.printStackTrace();
          }
        }
      };
    Kernel.execute(r);
  }

  /**
   * Binds this class to the JNDI tree under the name "HelloServer".
   */
  public static void main(String args[]) throws Exception {
     if (args.length > 0)
        remoteDomain = args[0];

     Pinger obj = new PingImpl();
     Context initialNamingContext = new InitialContext();
     initialNamingContext.rebind(NAME,obj);
     System.out.println("PingImpl created and bound to "+ NAME);
  }
}

