package examples.jdbc.informix4;
import java.util.Properties;
import java.sql.*;
import java.io.*;

/**
 *
 * This example makes a connection to a database that is using a
 * multibyte codeset. You will need to specify the proper URL and codeset
 * for your database. Consult your Informix installation guide for more
 * information.  
 * <p> 
 * The example inserts three Unicode characters into a
 * database and then performs a Select statement and reads the data back
 * into a Result Set. The data is then read in via getUnicodeStream,
 * converted to it's hexadecimal value, and displayed.
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li> Change connection parameters to correspond to your Informix Server configuration.
 * If you need more help, check the section on connecting
 * to a database in the programming guide, <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>.

 *
 * <p>
 * <li>Change the line containing <font face="Courier New"
 * size=-1>weblogic.codeset=myCodeset</font>, replacing <font
 * face="Courier New" size=-1>myCodeset</font> with the name of the
 * codeset used by your database. For testing, try using "<font
 * face="Courier New" size=-1>cp850</font>".
 *
 * <p>
 * <li>Compile this example using the following command line:
 * <pre>  $ <b>javac -d %CLIENT_CLASSES% PreparedStatementUnicode.java</b></pre>
 * 
 * </ol>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Execute the following command in your development shell: 
 * 
 * <pre><b>$ java examples.jdbc.informix4.PreparedStatementUnicode</b></pre>
 * 
 * </ol>
 * <h3>There's More</h3>
 *
 * For more information, see the programming guide  <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>. 
 * <p>
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All rights reserved
 */


public class PreparedStatementUnicode {

  public static void main (String argv[]) 
       throws SQLException {

      String user = "informix";
      String password = "secret";
      String server = "myDBHost";
      String port = "1493";
      String db = "myDB";
      String url = "jdbc:weblogic:informix4:myDB@myDBHost:1493";
      String codeset = "myCodeset";

      try {
        for (int i = 0; i < argv.length; i++) 
        {
          if (argv[i].equals("-user")) {
            i++; 
            user = (argv[i].equals("null") ? "" : argv[i]);
          } 
          else if (argv[i].equals("-password")) {
            i++; 
            password = (argv[i].equals("null") ? "" : argv[i]);
          }
          else if (argv[i].equals("-server")) {
            i++; 
            server = (argv[i].equals("null") ? "" : argv[i]);
          }
          else if (argv[i].equals("-port")) {
            i++; 
            port = (argv[i].equals("null") ? "" : argv[i]);
          }
          else if (argv[i].equals("-db")) {
            i++; 
            db = (argv[i].equals("null") ? "" : argv[i]);
          }
          else if (argv[i].equals("-url")) {
            i++; 
            url = (argv[i].equals("null") ? "" : argv[i]);
          }
          else if (argv[i].equals("-codeset")) {
            i++; 
            codeset = (argv[i].equals("null") ? "" : argv[i]);
          }
        }
      } catch(ArrayIndexOutOfBoundsException aiobe) {
        System.err.println("\nUsage: java examples.jdbc.informix4.PreparedStatementUnicode [options] \n\n" + 
                           "where options include:\n" +
                           "    -user <user>            User name to be passed to database.\n" +
                           "    -password <password>    User password to be passed to database.\n" +
                           "    -server <server>        DNS name of database server.\n" +
                           "    -port <port>            Port number of database server.\n" +
                           "    -db <db>                Name of database instance.\n" +
                           "    -url <url>              URL of database.\n" +
                           "    -codeset <codeset>      Name of codeset.\n");
        System.exit(1);
      }

      Driver myDriver = null;
      try {
        myDriver = (Driver) Class.forName("weblogic.jdbc.informix4.Driver").newInstance();
      }
      catch (Exception dr){
        System.out.println("unable to load driver");
      }  
  
      // Connect to your database. Substitute the proper database
      // name, server, codeset, user, and password 
      Properties props = new Properties();
      props.put("user",     user);
      props.put("password", password);
      props.put("server",   server); // hostname on which Informix server runs
      props.put("port",     port);       // port on which Informix server listens
      props.put("db",       db);  // name of database on Informix server
      props.put("weblogic.codeset", codeset); // name of codeset

      Connection c =  myDriver.connect("jdbc:weblogic:informix4", props);

      try {
        Statement ct = c.createStatement();
        ct.executeUpdate("CREATE TABLE dbtest (id smallint,tcol TEXT)");
      }
      catch (Exception cte){
        System.out.println("database already created");
      }

      //construct a prepared statement with one parameter
      PreparedStatement ps = 
          c.prepareStatement("insert into dbtest values (10,?)"); 
        
     // construct a UnicodeInputStream from a string and Insert it in
     // the database using the prepared statement 
     String s = new String("\u93e1\u68b0\u897f");
     weblogic.jdbc.informix4.UnicodeInputStream uis =
       new weblogic.jdbc.informix4.UnicodeInputStream(s);
     try {
       ps.setUnicodeStream(1,uis,uis.available());
     } 
     catch (java.io.IOException ioe) {
       System.out.println("IO Exception in setUnicodeStream");
     }
     ps.executeUpdate();
      
     // retrieve the data 
     Statement stmt = c.createStatement();
     stmt.execute("select * from dbtest");
     ResultSet rs = stmt.getResultSet();

     InputStream uisout;
     while (rs.next()) {
       uisout= rs.getUnicodeStream(2);
       
       //read in the UnicodeStream and display the bytes in hexadecimal
       int i = 0;   
       while (true) {
         try {
           i = uisout.read();
         } catch (IOException e) {
           System.out.println("IO exception reading Unicode stream");
         }
         if (i == -1) 
            break;
         System.out.println("Ox" + toHex(i) + "  ");
        }                
     }
     rs.close();
     stmt.close();
     c.close();
}

  // method to convert string to hexadecimal
  final static private char hex [] = 
  { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
    'A', 'B', 'C', 'D', 'E', 'F' };

  private static String toHex(int number) {
    String s = "";
    long v = number & 0xFFFFFFFF;

    for(int i = 0; (number > 0) || (i < 2); i++, number /= 16) {
        s = hex[number % 16] + s; 
    }
    return s;
  }
}











