package examples.jdbc.informix4;

import java.io.*;
import java.sql.*;
import java.util.Properties;

/**
 * 
 * This example shows how to insert data into an Informix BLOB column.
 * It demonstrates this by serializing an object and storing it in the
 * database and then retrieving the object.
 * <p>
 *
 *
 * <p><h3>Build the Example</h3>  
 * <ol>
 * <li> Open a new command shell. 
 * <p><li>Set up this development shell as described in 
 * <a href=../../examples.html#environment>Setting up Your Environment for 
 * Building and Running the Examples</a>.
 * <p>
 * <li> Change connection parameters to correspond to your Informix Server configuration.
 * If you need more help, check the section on connecting
 * to a database in the programming guide, <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>.
 * <p>
 * <li>Compile this example using the following command line:
 * <pre>  $ <b>javac -d %CLIENT_CLASSES% serializer.java</b></pre>
 * 
 * </ol>
 * <p><h3>Run the Example</h3>
 * <ol>
 * <li>Execute the following command in your development shell: 
 * 
 * <pre><b>$ java examples.jdbc.informix4.serializer</b></pre>
 * 
 * 
 * This example is run on the command line and is output to
 * System.out.</ol>

 * <h3>There's More</h3>
 *
 * For more information, see <a
 * href="http://e-docs.bea.com/wls/docs61/informix4/API_jinf4.html">Using WebLogic jDriver for Informix</a>. 
 * <p>
 *
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc.  All Rights Reserved.
 */

public class serializer {

  public static void main(String argv[]) {

    String user = "informix";
    String password = "secret";
    String server = "myDBHost";
    String port = "1493";
    String db = "myDB";
    String url = "jdbc:weblogic:informix4:myDB@myDBHost:1493";

    try {
      for (int i = 0; i < argv.length; i++) 
      {
        if (argv[i].equals("-user")) {
          i++; 
          user = (argv[i].equals("null") ? "" : argv[i]);
        } 
        else if (argv[i].equals("-password")) {
          i++; 
          password = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-server")) {
          i++; 
          server = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-port")) {
          i++; 
          port = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-db")) {
          i++; 
          db = (argv[i].equals("null") ? "" : argv[i]);
        }
        else if (argv[i].equals("-url")) {
          i++; 
          url = (argv[i].equals("null") ? "" : argv[i]);
        }
      }
    } catch(ArrayIndexOutOfBoundsException aiobe) {
      System.err.println("\nUsage: java examples.jdbc.informix4.serializer [options] \n\n" +
                         "where options include:\n" +
                         "    -user <user>            User name to be passed to database.\n" +
                         "    -password <password>    User password to be passed to database.\n" +
                         "    -server <server>        DNS name of database server.\n" +
                         "    -port <port>            Port number of database server.\n" +
                         "    -db <db>                Name of database instance.\n" +
                         "    -url <url>              URL of database.\n");
      System.exit(1);
    }

    java.sql.Connection conn         = null;
    java.sql.Statement stmt          = null;
    java.sql.ResultSet rs            = null;
    java.sql.PreparedStatement pstmt = null;
    
    try { 
      Properties props = new Properties();
      props.put("user",     user);
      props.put("password", password);
      props.put("server",   server); // hostname on which Informix server runs
      props.put("port",     port);       // port on which Informix server listens
      props.put("db",       db);  // name of database on Informix server

      Driver myDriver = (Driver) Class.forName("weblogic.jdbc.informix4.Driver").newInstance();
      conn = myDriver.connect("jdbc:weblogic:informix4", props);

      stmt = conn.createStatement();
      try {
        stmt.execute("drop table blobtest");
        System.out.println("Dropped table blobtest");
      }
      catch (SQLException e) {
        // table does not exist
      }
      stmt.execute("create table blobtest (foo byte)");
      System.out.println("creating blobtest table");

      // create an instance of aClass and serialize it into a byte array
      aClass a = new aClass(1234);
      System.out.println("Created aClass with value 1234");
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream (baos);
      oos.writeObject(a);
      byte[] aBytes = baos.toByteArray();

      // write the byte array to the database
      pstmt = conn.prepareStatement("insert into blobtest(foo) values (?)");
      pstmt.setBinaryStream(1, new ByteArrayInputStream(aBytes),aBytes.length);
      pstmt.executeUpdate();
      System.out.println("Inserted aClass into the database");
      a = null;
      aBytes = null;

      // retrieve the serialized object back from the database and instantiate a new copy
      rs = stmt.executeQuery("select foo from blobtest");
      rs.next();
      ObjectInputStream ois = new ObjectInputStream(rs.getBinaryStream(1));
      aClass newa = (aClass)ois.readObject();
      System.out.println("Retrieved the aClass object from the database with value " + newa.getVal());
    } catch (Exception e) {
        System.out.println("Caught Exception: " + e.getMessage());
    } finally {
        try {
          if (stmt != null)
            stmt.close();
          if (pstmt != null)
            pstmt.close();
          if (rs != null)
            rs.close();
          if (conn != null)
            conn.close();
        } catch (SQLException sqle) {
            System.out.println("SQLExcption was thrown: " + sqle.getMessage());
        }
    }

  }

}
/**
 * This class implements serializable. This class is used by the serializer.java example.

 */ 
class aClass implements Serializable {
  int aValue;
  public aClass(int v) { aValue = v; }
  public int getVal() { return aValue; }
}
